/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.direct;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.encoder.direct.AbstractAvroDirectEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/direct/ArrayDirectEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/direct/AbstractAvroDirectEncoder;", "arraySchema", "Lorg/apache/avro/Schema;", "arraySize", "", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "binaryEncoder", "Lorg/apache/avro/io/Encoder;", "<init>", "(Lorg/apache/avro/Schema;ILcom/github/avrokotlin/avro4k/Avro;Lorg/apache/avro/io/Encoder;)V", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "encodeElement", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "endStructure", "", "core"})
public final class ArrayDirectEncoder
extends AbstractAvroDirectEncoder {
    @NotNull
    private final Schema arraySchema;
    public Schema currentWriterSchema;

    public ArrayDirectEncoder(@NotNull Schema arraySchema, int arraySize, @NotNull Avro avro, @NotNull Encoder binaryEncoder) {
        Intrinsics.checkNotNullParameter((Object)arraySchema, (String)"arraySchema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)binaryEncoder, (String)"binaryEncoder");
        super(avro, binaryEncoder, null);
        this.arraySchema = arraySchema;
        binaryEncoder.writeArrayStart();
        binaryEncoder.setItemCount((long)arraySize);
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.currentWriterSchema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentWriterSchema");
        return null;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super.encodeElement(descriptor, index);
        this.getBinaryEncoder().startItem();
        Schema schema = this.arraySchema.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"getElementType(...)");
        this.setCurrentWriterSchema(schema);
        return true;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.getBinaryEncoder().writeArrayEnd();
    }
}

