/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.direct;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.MissingFieldsEncodingException;
import com.github.avrokotlin.avro4k.internal.EncodingWorkflow;
import com.github.avrokotlin.avro4k.internal.encoder.ReorderingCompositeEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.direct.RecordContiguousExactEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.direct.RecordContiguousSkippingEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.direct.RecordNonContiguousEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\n"}, d2={"RecordDirectEncoder", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "schema", "Lorg/apache/avro/Schema;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "binaryEncoder", "Lorg/apache/avro/io/Encoder;", "core"})
@SourceDebugExtension(value={"SMAP\nRecordDirectEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordDirectEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/direct/RecordDirectEncoderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n774#2:102\n865#2,2:103\n*S KotlinDebug\n*F\n+ 1 RecordDirectEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/direct/RecordDirectEncoderKt\n*L\n35#1:102\n35#1:103,2\n*E\n"})
public final class RecordDirectEncoderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CompositeEncoder RecordDirectEncoder(@NotNull SerialDescriptor descriptor, @NotNull Schema schema, @NotNull Avro avro, @NotNull Encoder binaryEncoder) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)binaryEncoder, (String)"binaryEncoder");
        EncodingWorkflow encodingWorkflow = avro.getRecordResolver$core().resolveFields(schema, descriptor).getEncoding();
        if (encodingWorkflow instanceof EncodingWorkflow.ExactMatch) {
            compositeEncoder = (CompositeEncoder)new RecordContiguousExactEncoder(schema, avro, binaryEncoder);
        } else if (encodingWorkflow instanceof EncodingWorkflow.ContiguousWithSkips) {
            compositeEncoder = (CompositeEncoder)new RecordContiguousSkippingEncoder(((EncodingWorkflow.ContiguousWithSkips)encodingWorkflow).getFieldsToSkip(), schema, avro, binaryEncoder);
        } else if (encodingWorkflow instanceof EncodingWorkflow.NonContiguous) {
            compositeEncoder = new ReorderingCompositeEncoder(schema.getFields().size(), (CompositeEncoder)new RecordNonContiguousEncoder(((EncodingWorkflow.NonContiguous)encodingWorkflow).getDescriptorToWriterFieldIndex(), schema, avro, binaryEncoder), (Function2<? super SerialDescriptor, ? super Integer, Integer>)((Function2)(arg_0, arg_1) -> RecordDirectEncoderKt.RecordDirectEncoder$lambda$0(encodingWorkflow, arg_0, arg_1)));
        } else {
            if (encodingWorkflow instanceof EncodingWorkflow.MissingWriterFields) {
                void $this$filterTo$iv$iv;
                List list = schema.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Schema.Field it = (Schema.Field)element$iv$iv;
                    boolean bl = false;
                    if (!((EncodingWorkflow.MissingWriterFields)encodingWorkflow).getMissingWriterFields().contains(it.pos())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                SerialDescriptor serialDescriptor = descriptor;
                Schema schema2 = schema;
                List list2 = (List)destination$iv$iv;
                throw new MissingFieldsEncodingException(list2, schema2, serialDescriptor);
            }
            throw new NoWhenBranchMatchedException();
        }
        return compositeEncoder;
    }

    private static final int RecordDirectEncoder$lambda$0(EncodingWorkflow $encodingWorkflow, SerialDescriptor serialDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)serialDescriptor, (String)"<unused var>");
        return ((EncodingWorkflow.NonContiguous)$encodingWorkflow).getDescriptorToWriterFieldIndex()[index];
    }
}

