/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.encoder.generic.AbstractAvroGenericEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0006\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/generic/AvroValueGenericEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/generic/AbstractAvroGenericEncoder;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "currentWriterSchema", "Lorg/apache/avro/Schema;", "onEncoded", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/github/avrokotlin/avro4k/Avro;Lorg/apache/avro/Schema;Lkotlin/jvm/functions/Function1;)V", "getAvro", "()Lcom/github/avrokotlin/avro4k/Avro;", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "encodeValue", "value", "encodeNullUnchecked", "core"})
public final class AvroValueGenericEncoder
extends AbstractAvroGenericEncoder {
    @NotNull
    private final Avro avro;
    @NotNull
    private Schema currentWriterSchema;
    @NotNull
    private final Function1<Object, Unit> onEncoded;

    public AvroValueGenericEncoder(@NotNull Avro avro, @NotNull Schema currentWriterSchema, @NotNull Function1<Object, Unit> onEncoded) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)currentWriterSchema, (String)"currentWriterSchema");
        Intrinsics.checkNotNullParameter(onEncoded, (String)"onEncoded");
        this.avro = avro;
        this.currentWriterSchema = currentWriterSchema;
        this.onEncoded = onEncoded;
    }

    @Override
    @NotNull
    public Avro getAvro() {
        return this.avro;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        return this.currentWriterSchema;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    @Override
    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.onEncoded.invoke(value);
    }

    @Override
    public void encodeNullUnchecked() {
        this.onEncoded.invoke(null);
    }
}

