/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.schema;

import com.github.avrokotlin.avro4k.AvroDefault;
import com.github.avrokotlin.avro4k.AvroDoc;
import com.github.avrokotlin.avro4k.AvroProp;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.schema.ClassVisitorKt;
import com.github.avrokotlin.avro4k.internal.schema.FieldAnnotations;
import com.github.avrokotlin.avro4k.internal.schema.SerialDescriptorClassVisitor;
import com.github.avrokotlin.avro4k.internal.schema.SerialDescriptorValueVisitor;
import com.github.avrokotlin.avro4k.internal.schema.TypeAnnotations;
import com.github.avrokotlin.avro4k.internal.schema.ValueVisitor;
import com.github.avrokotlin.avro4k.internal.schema.VisitorContext;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J&\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/github/avrokotlin/avro4k/internal/schema/ClassVisitor;", "Lcom/github/avrokotlin/avro4k/internal/schema/SerialDescriptorClassVisitor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "context", "Lcom/github/avrokotlin/avro4k/internal/schema/VisitorContext;", "onSchemaBuilt", "Lkotlin/Function1;", "Lorg/apache/avro/Schema;", "", "<init>", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lcom/github/avrokotlin/avro4k/internal/schema/VisitorContext;Lkotlin/jvm/functions/Function1;)V", "fields", "", "Lorg/apache/avro/Schema$Field;", "schemaAlreadyResolved", "", "schema", "visitClassElement", "Lcom/github/avrokotlin/avro4k/internal/schema/SerialDescriptorValueVisitor;", "elementIndex", "", "endClassVisit", "createField", "fieldName", "", "annotations", "Lcom/github/avrokotlin/avro4k/internal/schema/FieldAnnotations;", "elementSchema", "getDefaultAndReorderUnionIfNeeded", "Lkotlin/Pair;", "", "core"})
@SourceDebugExtension(value={"SMAP\nClassVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassVisitor.kt\ncom/github/avrokotlin/avro4k/internal/schema/ClassVisitor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n382#2,3:212\n385#2,4:219\n13805#3,2:215\n13805#3,2:223\n1321#4,2:217\n1321#4,2:225\n1878#5,3:227\n1761#5,3:230\n*S KotlinDebug\n*F\n+ 1 ClassVisitor.kt\ncom/github/avrokotlin/avro4k/internal/schema/ClassVisitor\n*L\n34#1:212,3\n34#1:219,4\n49#1:215,2\n104#1:223,2\n50#1:217,2\n105#1:225,2\n118#1:227,3\n132#1:230,3\n*E\n"})
public final class ClassVisitor
implements SerialDescriptorClassVisitor {
    @NotNull
    private final VisitorContext context;
    @NotNull
    private final Function1<Schema, Unit> onSchemaBuilt;
    @NotNull
    private final List<Schema.Field> fields;
    private final boolean schemaAlreadyResolved;
    @NotNull
    private final Schema schema;

    /*
     * WARNING - void declaration
     */
    public ClassVisitor(@NotNull SerialDescriptor descriptor, @NotNull VisitorContext context, @NotNull Function1<? super Schema, Unit> onSchemaBuilt) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onSchemaBuilt, (String)"onSchemaBuilt");
        this.context = context;
        this.onSchemaBuilt = onSchemaBuilt;
        this.fields = new ArrayList();
        boolean schemaAlreadyResolved = false;
        schemaAlreadyResolved = true;
        ClassVisitor classVisitor = this;
        Map<String, Schema> map = this.context.getResolvedSchemas();
        String key$iv = HelpersKt.getNonNullSerialName(descriptor);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            ClassVisitor classVisitor2 = classVisitor;
            boolean bl = false;
            schemaAlreadyResolved = false;
            TypeAnnotations annotations = new TypeAnnotations(descriptor);
            AvroDoc avroDoc = annotations.getDoc();
            Schema schema = Schema.createRecord((String)HelpersKt.getNonNullSerialName(descriptor), (String)(avroDoc != null ? avroDoc.value() : null), null, (boolean)false);
            String[] stringArray = annotations.getAliases();
            if (stringArray != null && (stringArray = stringArray.value()) != null) {
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    schema.addAlias(it);
                }
            }
            Sequence<AvroProp> $this$forEach$iv = annotations.getProps();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AvroProp it = (AvroProp)element$iv;
                boolean bl3 = false;
                schema.addProp(it.key(), (Object)HelpersKt.getJsonNode(it));
            }
            Intrinsics.checkNotNull((Object)schema);
            classVisitor = classVisitor2;
            Schema answer$iv = schema;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        classVisitor.schema = (Schema)object;
        this.schemaAlreadyResolved = schemaAlreadyResolved;
    }

    @Override
    @Nullable
    public SerialDescriptorValueVisitor visitClassElement(@NotNull SerialDescriptor descriptor, int elementIndex) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.schemaAlreadyResolved) {
            return null;
        }
        return new ValueVisitor(VisitorContext.copy$default(this.context, null, null, CollectionsKt.listOf((Object)new ElementLocation(descriptor, elementIndex)), 3, null), (Function1<? super Schema, Unit>)((Function1)arg_0 -> ClassVisitor.visitClassElement$lambda$0(this, descriptor, elementIndex, arg_0)));
    }

    @Override
    public void endClassVisit(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.schemaAlreadyResolved) {
            this.schema.setFields(this.fields);
        }
        this.onSchemaBuilt.invoke((Object)this.schema);
    }

    private final Schema.Field createField(String fieldName, FieldAnnotations annotations, Schema elementSchema) {
        Pair<Schema, Object> pair = this.getDefaultAndReorderUnionIfNeeded(annotations, elementSchema);
        Schema finalSchema = (Schema)pair.component1();
        Object fieldDefault = pair.component2();
        AvroDoc avroDoc = annotations.getDoc();
        Schema.Field field = new Schema.Field(fieldName, finalSchema, avroDoc != null ? avroDoc.value() : null, fieldDefault);
        String[] stringArray = annotations.getAliases();
        if (stringArray != null && (stringArray = stringArray.value()) != null) {
            String[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                field.addAlias(it);
            }
        }
        Sequence<AvroProp> $this$forEach$iv = annotations.getProps();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvroProp it = (AvroProp)element$iv;
            boolean bl = false;
            field.addProp(it.key(), (Object)HelpersKt.getJsonNode(it));
        }
        return field;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Schema, Object> getDefaultAndReorderUnionIfNeeded(FieldAnnotations annotations, Schema elementSchema) {
        Object defaultValue;
        AvroDefault avroDefault = annotations.getDefault();
        Object object = defaultValue = avroDefault != null ? ClassVisitorKt.access$toAvroObject(avroDefault) : null;
        if (defaultValue == null) {
            if (this.context.getConfiguration().getImplicitNulls() && elementSchema.isNullable()) {
                return TuplesKt.to((Object)ClassVisitorKt.access$moveToHeadOfUnion(elementSchema, ClassVisitor::getDefaultAndReorderUnionIfNeeded$lambda$0), (Object)JsonProperties.NULL_VALUE);
            }
            if (this.context.getConfiguration().getImplicitEmptyCollections()) {
                Iterable $this$forEachIndexed$iv = HelpersKt.asSchemaList(elementSchema);
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void schema;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Schema schema2 = (Schema)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (schema.getType() == Schema.Type.ARRAY) {
                        return TuplesKt.to((Object)ClassVisitorKt.access$moveToHeadOfUnion(elementSchema, index), (Object)CollectionsKt.emptyList());
                    }
                    if (schema.getType() != Schema.Type.MAP) continue;
                    return TuplesKt.to((Object)ClassVisitorKt.access$moveToHeadOfUnion(elementSchema, index), (Object)MapsKt.emptyMap());
                }
            }
        } else {
            boolean bl;
            block14: {
                if (defaultValue == JsonProperties.NULL_VALUE) {
                    Schema finalSchema = ClassVisitorKt.access$moveToHeadOfUnion(elementSchema, ClassVisitor::getDefaultAndReorderUnionIfNeeded$lambda$2);
                    Object adaptedDefault = !elementSchema.isNullable() ? "null" : defaultValue;
                    return TuplesKt.to((Object)finalSchema, (Object)adaptedDefault);
                }
                Iterable $this$any$iv = HelpersKt.asSchemaList(elementSchema);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Schema it = (Schema)element$iv;
                        boolean bl2 = false;
                        LogicalType logicalType = it.getLogicalType();
                        if (!Intrinsics.areEqual((Object)(logicalType != null ? logicalType.getName() : null), (Object)"char")) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                if (defaultValue instanceof String && ((String)defaultValue).length() == 1) {
                    return TuplesKt.to((Object)ClassVisitorKt.access$moveToHeadOfUnion(elementSchema, ClassVisitor::getDefaultAndReorderUnionIfNeeded$lambda$4), (Object)StringsKt.single((CharSequence)((CharSequence)defaultValue)));
                }
                throw new SerializationException("Default value for Char must be a single character string. Invalid value of type " + Reflection.getOrCreateKotlinClass(defaultValue.getClass()).getQualifiedName() + ": " + defaultValue);
            }
            if (elementSchema.isNullable()) {
                return TuplesKt.to((Object)ClassVisitorKt.access$moveToTailOfUnion(elementSchema, ClassVisitor::getDefaultAndReorderUnionIfNeeded$lambda$5), (Object)defaultValue);
            }
        }
        return TuplesKt.to((Object)elementSchema, (Object)defaultValue);
    }

    private static final Unit visitClassElement$lambda$0(ClassVisitor this$0, SerialDescriptor $descriptor, int $elementIndex, Schema fieldSchema) {
        Intrinsics.checkNotNullParameter((Object)fieldSchema, (String)"fieldSchema");
        this$0.fields.add(this$0.createField(this$0.context.getAvro().getConfiguration().getFieldNamingStrategy().resolve($descriptor, $elementIndex), new FieldAnnotations($descriptor, $elementIndex), fieldSchema));
        return Unit.INSTANCE;
    }

    private static final boolean getDefaultAndReorderUnionIfNeeded$lambda$0(Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() == Schema.Type.NULL;
    }

    private static final boolean getDefaultAndReorderUnionIfNeeded$lambda$2(Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() == Schema.Type.NULL;
    }

    private static final boolean getDefaultAndReorderUnionIfNeeded$lambda$4(Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LogicalType logicalType = it.getLogicalType();
        return Intrinsics.areEqual((Object)(logicalType != null ? logicalType.getName() : null), (Object)"char");
    }

    private static final boolean getDefaultAndReorderUnionIfNeeded$lambda$5(Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType() == Schema.Type.NULL;
    }
}

