/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.schema;

import com.github.avrokotlin.avro4k.internal.AvroSchemaGenerationException;
import com.github.avrokotlin.avro4k.internal.schema.SerialDescriptorPolymorphicVisitor;
import com.github.avrokotlin.avro4k.internal.schema.SerialDescriptorValueVisitor;
import com.github.avrokotlin.avro4k.internal.schema.ValueVisitor;
import com.github.avrokotlin.avro4k.internal.schema.VisitorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/github/avrokotlin/avro4k/internal/schema/PolymorphicVisitor;", "Lcom/github/avrokotlin/avro4k/internal/schema/SerialDescriptorPolymorphicVisitor;", "context", "Lcom/github/avrokotlin/avro4k/internal/schema/VisitorContext;", "onSchemaBuilt", "Lkotlin/Function1;", "Lorg/apache/avro/Schema;", "", "<init>", "(Lcom/github/avrokotlin/avro4k/internal/schema/VisitorContext;Lkotlin/jvm/functions/Function1;)V", "possibleSchemas", "", "visitPolymorphicFoundDescriptor", "Lcom/github/avrokotlin/avro4k/internal/schema/SerialDescriptorValueVisitor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "endPolymorphicVisit", "core"})
public final class PolymorphicVisitor
implements SerialDescriptorPolymorphicVisitor {
    @NotNull
    private final VisitorContext context;
    @NotNull
    private final Function1<Schema, Unit> onSchemaBuilt;
    @NotNull
    private final List<Schema> possibleSchemas;

    public PolymorphicVisitor(@NotNull VisitorContext context, @NotNull Function1<? super Schema, Unit> onSchemaBuilt) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(onSchemaBuilt, (String)"onSchemaBuilt");
        this.context = context;
        this.onSchemaBuilt = onSchemaBuilt;
        this.possibleSchemas = new ArrayList();
    }

    @Override
    @NotNull
    public SerialDescriptorValueVisitor visitPolymorphicFoundDescriptor(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new ValueVisitor(this.context, (Function1<? super Schema, Unit>)((Function1)arg_0 -> PolymorphicVisitor.visitPolymorphicFoundDescriptor$lambda$0(this, arg_0)));
    }

    @Override
    public void endPolymorphicVisit(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.possibleSchemas.isEmpty()) {
            throw new AvroSchemaGenerationException("Polymorphic descriptor '" + descriptor + "' must have at least one possible schema");
        }
        if (this.possibleSchemas.size() == 1) {
            this.onSchemaBuilt.invoke(CollectionsKt.first(this.possibleSchemas));
        } else {
            Schema schema = Schema.createUnion(this.possibleSchemas);
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"createUnion(...)");
            this.onSchemaBuilt.invoke((Object)schema);
        }
    }

    private static final Unit visitPolymorphicFoundDescriptor$lambda$0(PolymorphicVisitor this$0, Schema it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Collection)this$0.possibleSchemas).add(it);
        return Unit.INSTANCE;
    }
}

