/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.serializer;

import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroStringable;
import com.github.avrokotlin.avro4k.serializer.AvroDuration;
import com.github.avrokotlin.avro4k.serializer.AvroDurationSerializer;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.AvroSerializerKt;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0002*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0002H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/github/avrokotlin/avro4k/serializer/JavaDurationSerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "Ljava/time/Duration;", "<init>", "()V", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "toJavaDuration", "Lcom/github/avrokotlin/avro4k/serializer/AvroDuration;", "toAvroDuration", "core"})
public final class JavaDurationSerializer
extends AvroSerializer<Duration> {
    @NotNull
    public static final JavaDurationSerializer INSTANCE = new JavaDurationSerializer();

    private JavaDurationSerializer() {
        String string = Reflection.getOrCreateKotlinClass(Duration.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        Schema schema;
        Schema schema2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            for (ElementLocation it : (Iterable)context.getInlinedElements()) {
                boolean bl = false;
                AvroStringable avroStringable = AvroSerializerKt.getStringable(it);
                Object object = avroStringable != null ? AvroSerializerKt.createSchema(avroStringable) : null;
                if (object == null) continue;
                schema2 = object;
                break block2;
            }
            schema2 = schema = null;
        }
        if (schema2 == null) {
            Schema schema3 = AvroDurationSerializer.INSTANCE.getDURATION_SCHEMA$core();
            schema = schema3;
            Intrinsics.checkNotNullExpressionValue((Object)schema3, (String)"<get-DURATION_SCHEMA>(...)");
        }
        return schema;
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull Duration value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AvroDurationSerializer.INSTANCE.serializeAvro(encoder, this.toAvroDuration(value));
    }

    @Override
    @NotNull
    public Duration deserializeAvro(@NotNull AvroDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return this.toJavaDuration(AvroDurationSerializer.INSTANCE.deserializeAvro(decoder));
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull Duration value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    @Override
    @NotNull
    public Duration deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Duration duration = Duration.parse(decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parse(...)");
        return duration;
    }

    private final Duration toJavaDuration(AvroDuration $this$toJavaDuration) {
        if ($this$toJavaDuration.getMonths-pVg5ArA() != 0) {
            throw new SerializationException("java.time.Duration cannot contains months");
        }
        Duration duration = Duration.ofMillis(((long)$this$toJavaDuration.getDays-pVg5ArA() & 0xFFFFFFFFL) * (long)86400000 + ((long)$this$toJavaDuration.getMillis-pVg5ArA() & 0xFFFFFFFFL));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    private final AvroDuration toAvroDuration(Duration $this$toAvroDuration) {
        if ($this$toAvroDuration.isNegative()) {
            throw new SerializationException(Reflection.getOrCreateKotlinClass(Duration.class).getQualifiedName() + " cannot be converted to " + Reflection.getOrCreateKotlinClass(AvroDuration.class).getQualifiedName() + " as it cannot be negative");
        }
        long millis = $this$toAvroDuration.toMillis();
        return new AvroDuration(0, UInt.constructor-impl((int)((int)(millis / (long)86400000))), UInt.constructor-impl((int)((int)(millis % (long)86400000))), null);
    }
}

