/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.serializer;

import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/avrokotlin/avro4k/serializer/UUIDSerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "Ljava/util/UUID;", "<init>", "()V", "LOGICAL_TYPE_NAME", "", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "core"})
public final class UUIDSerializer
extends AvroSerializer<UUID> {
    @NotNull
    public static final UUIDSerializer INSTANCE = new UUIDSerializer();
    @NotNull
    public static final String LOGICAL_TYPE_NAME = "uuid";

    private UUIDSerializer() {
        String string = Reflection.getOrCreateKotlinClass(UUID.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"create(...)");
        return HelpersKt.copy$default(schema, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, new LogicalType(LOGICAL_TYPE_NAME), null, 49151, null);
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.serializeGeneric((Encoder)encoder, value);
    }

    @Override
    @NotNull
    public UUID deserializeAvro(@NotNull AvroDecoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return this.deserializeGeneric(decoder);
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    @Override
    @NotNull
    public UUID deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        UUID uUID = UUID.fromString(decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return uUID;
    }
}

