/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.AvroKotlinxIoExtensionsKt;
import com.github.avrokotlin.avro4k.AvroSingleObjectKt;
import com.github.avrokotlin.avro4k.ExperimentalAvro4kApi;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.jetbrains.annotations.NotNull;

@ExperimentalAvro4kApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B6\u0012#\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u0015\u001a\u00020\u0016*\u00020\bH\u0002J9\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001c2\u0006\u0010\u001d\u001a\u0002H\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0007\u00a2\u0006\u0002\u0010 J7\u0010!\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001c2\u0006\u0010\u001d\u001a\u0002H\u00192\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010$J)\u0010%\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00190'2\u0006\u0010(\u001a\u00020)H\u0007\u00a2\u0006\u0002\u0010*J'\u0010+\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00190'2\u0006\u0010,\u001a\u00020-\u00a2\u0006\u0002\u0010.J)\u0010/\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00190'2\u0006\u00100\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u00101J)\u00102\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001c2\u0006\u0010\u001d\u001a\u0002H\u0019H\u0016\u00a2\u0006\u0002\u00103R+\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00064"}, d2={"Lcom/github/avrokotlin/avro4k/AvroSingleObject;", "Lkotlinx/serialization/BinaryFormat;", "schemaRegistry", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fingerprint", "Lorg/apache/avro/Schema;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "<init>", "(Lkotlin/jvm/functions/Function1;Lcom/github/avrokotlin/avro4k/Avro;)V", "getAvro$annotations", "()V", "getAvro", "()Lcom/github/avrokotlin/avro4k/Avro;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "crc64avro", "", "encodeToStream", "", "T", "writerSchema", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "value", "outputStream", "Ljava/io/OutputStream;", "(Lorg/apache/avro/Schema;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Ljava/io/OutputStream;)V", "encodeToSink", "sink", "Lkotlinx/io/Sink;", "(Lorg/apache/avro/Schema;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlinx/io/Sink;)V", "decodeFromStream", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "inputStream", "Ljava/io/InputStream;", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/io/InputStream;)Ljava/lang/Object;", "decodeFromSource", "source", "Lkotlinx/io/Source;", "(Lkotlinx/serialization/DeserializationStrategy;Lkotlinx/io/Source;)Ljava/lang/Object;", "decodeFromByteArray", "bytes", "(Lkotlinx/serialization/DeserializationStrategy;[B)Ljava/lang/Object;", "encodeToByteArray", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)[B", "core"})
@SourceDebugExtension(value={"SMAP\nAvroSingleObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvroSingleObject.kt\ncom/github/avrokotlin/avro4k/AvroSingleObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class AvroSingleObject
implements BinaryFormat {
    @NotNull
    private final Function1<Long, Schema> schemaRegistry;
    @NotNull
    private final Avro avro;

    public AvroSingleObject(@NotNull Function1<? super Long, ? extends Schema> schemaRegistry, @NotNull Avro avro) {
        Intrinsics.checkNotNullParameter(schemaRegistry, (String)"schemaRegistry");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        this.schemaRegistry = schemaRegistry;
        this.avro = avro;
    }

    public /* synthetic */ AvroSingleObject(Function1 function1, Avro avro, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            avro = Avro.Default;
        }
        this((Function1<? super Long, ? extends Schema>)function1, avro);
    }

    @NotNull
    public final Avro getAvro() {
        return this.avro;
    }

    @PublishedApi
    public static /* synthetic */ void getAvro$annotations() {
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.avro.getSerializersModule();
    }

    private final byte[] crc64avro(Schema $this$crc64avro) {
        byte[] byArray = SchemaNormalization.parsingFingerprint((String)"CRC-64-AVRO", (Schema)$this$crc64avro);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"parsingFingerprint(...)");
        return byArray;
    }

    @Deprecated(message="Use encodeToSink instead", replaceWith=@ReplaceWith(expression="encodeToSink(writerSchema, serializer, value, outputStream.asSink().buffered())", imports={}))
    public final <T> void encodeToStream(@NotNull Schema writerSchema, @NotNull SerializationStrategy<? super T> serializer, T value, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)writerSchema, (String)"writerSchema");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.encodeToSink(writerSchema, serializer, value, CoreKt.buffered((RawSink)JvmCoreKt.asSink((OutputStream)outputStream)));
    }

    public final <T> void encodeToSink(@NotNull Schema writerSchema, @NotNull SerializationStrategy<? super T> serializer, T value, @NotNull Sink sink) {
        Intrinsics.checkNotNullParameter((Object)writerSchema, (String)"writerSchema");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.writeByte((byte)-61);
        sink.writeByte((byte)1);
        Sink.write$default((Sink)sink, (byte[])this.crc64avro(writerSchema), (int)0, (int)0, (int)6, null);
        AvroKotlinxIoExtensionsKt.encodeToSink(this.avro, writerSchema, serializer, value, sink);
    }

    @Deprecated(message="Use decodeFromSource instead", replaceWith=@ReplaceWith(expression="decodeFromSource(deserializer, inputStream.asSource().buffered())", imports={}))
    public final <T> T decodeFromStream(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return this.decodeFromSource(deserializer, CoreKt.buffered((RawSource)JvmCoreKt.asSource((InputStream)inputStream)));
    }

    public final <T> T decodeFromSource(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull Source source) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(source.readByte() == -61)) {
            boolean $i$a$-check-AvroSingleObject$decodeFromSource$32 = false;
            String $i$a$-check-AvroSingleObject$decodeFromSource$32 = "Not a valid single-object avro format, bad magic byte";
            throw new IllegalStateException($i$a$-check-AvroSingleObject$decodeFromSource$32.toString());
        }
        if (!(source.readByte() == 1)) {
            boolean bl = false;
            String string = "Not a valid single-object avro format, bad version byte";
            throw new IllegalStateException(string.toString());
        }
        long fingerprint = SourcesKt.readLongLe((Source)source);
        Schema schema = (Schema)this.schemaRegistry.invoke((Object)fingerprint);
        if (schema == null) {
            StringBuilder stringBuilder = new StringBuilder().append("schema not found for the given object's schema fingerprint 0x");
            String string = Long.toString(fingerprint, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new SerializationException(stringBuilder.append(string).toString());
        }
        Schema writerSchema = schema;
        return AvroKotlinxIoExtensionsKt.decodeFromSource(this.avro, writerSchema, deserializer, source);
    }

    public <T> T decodeFromByteArray(@NotNull DeserializationStrategy<? extends T> deserializer, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.decodeFromSource(deserializer, (Source)HelpersKt.Buffer(bytes));
    }

    @NotNull
    public <T> byte[] encodeToByteArray(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Schema writerSchema = this.avro.schema(serializer.getDescriptor());
        return AvroSingleObjectKt.encodeToByteArray(this, writerSchema, serializer, value);
    }
}

