/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.decoder.direct;

import com.github.avrokotlin.avro4k.internal.decoder.direct.KotlinxIoDecoderKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.Source;
import kotlinx.io.SourcesJvmKt;
import kotlinx.io.SourcesKt;
import kotlinx.io.Utf8Kt;
import kotlinx.io.unsafe.SegmentReadContext;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import kotlinx.io.unsafe.UnsafeBufferOperationsKt;
import org.apache.avro.SystemLimitException;
import org.apache.avro.io.Decoder;
import org.apache.avro.util.Utf8;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0012\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u000bH\u0016J\b\u0010!\u001a\u00020\rH\u0016J\b\u0010\"\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020\rH\u0016J\b\u0010$\u001a\u00020\rH\u0016J\b\u0010%\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020\rH\u0016J\b\u0010'\u001a\u00020\rH\u0002J\b\u0010(\u001a\u00020\rH\u0002J\b\u0010)\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/github/avrokotlin/avro4k/internal/decoder/direct/KotlinxIoDecoder;", "Lorg/apache/avro/io/Decoder;", "source", "Lkotlinx/io/Source;", "<init>", "(Lkotlinx/io/Source;)V", "readNull", "", "readBoolean", "", "readInt", "", "readLong", "", "readFloat", "", "readDouble", "", "readString", "Lorg/apache/avro/util/Utf8;", "old", "", "skipString", "readBytes", "Ljava/nio/ByteBuffer;", "skipBytes", "readFixed", "bytes", "", "start", "length", "skipFixed", "readEnum", "readArrayStart", "readMapStart", "arrayNext", "mapNext", "skipArray", "skipMap", "doReadItemCount", "doSkipItems", "readIndex", "core"})
@SourceDebugExtension(value={"SMAP\nKotlinxIoDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinxIoDecoder.kt\ncom/github/avrokotlin/avro4k/internal/decoder/direct/KotlinxIoDecoder\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperationsKt\n*L\n1#1,291:1\n378#2,3:292\n381#2,3:296\n434#3:295\n*S KotlinDebug\n*F\n+ 1 KotlinxIoDecoder.kt\ncom/github/avrokotlin/avro4k/internal/decoder/direct/KotlinxIoDecoder\n*L\n67#1:292,3\n67#1:296,3\n74#1:295\n*E\n"})
public final class KotlinxIoDecoder
extends Decoder {
    @NotNull
    private final Source source;

    public KotlinxIoDecoder(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    public void readNull() {
    }

    public boolean readBoolean() {
        return this.source.readByte() == 1;
    }

    public int readInt() {
        return KotlinxIoDecoderKt.access$readVarInt(this.source);
    }

    public long readLong() {
        return KotlinxIoDecoderKt.access$readVarLong(this.source);
    }

    public float readFloat() {
        return SourcesKt.readFloatLe((Source)this.source);
    }

    public double readDouble() {
        return SourcesKt.readDoubleLe((Source)this.source);
    }

    @NotNull
    public Utf8 readString(@Nullable Utf8 old) {
        return new Utf8(SourcesKt.readByteArray((Source)this.source, (int)SystemLimitException.checkMaxStringLength((long)this.readLong())));
    }

    @NotNull
    public String readString() {
        return Utf8Kt.readString((Source)this.source, (long)this.readLong());
    }

    public void skipString() {
        this.source.skip(this.readLong());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ByteBuffer readBytes(@Nullable ByteBuffer old) {
        int length = SystemLimitException.checkMaxBytesLength((long)this.readLong());
        this.source.require((long)length);
        if (old != null && length <= old.capacity()) {
            old.clear().limit(length);
            SourcesJvmKt.readAtMostTo((Source)this.source, (ByteBuffer)old);
            return old;
        }
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer$iv = this.source.getBuffer();
        boolean $i$f$forEachSegment = false;
        Segment curr$iv = buffer$iv.getHead();
        if (curr$iv != null) {
            void offset;
            void segment;
            Segment segment2 = curr$iv;
            SegmentReadContext ctx = UnsafeBufferOperationsKt.getSegmentReadContextImpl();
            boolean bl = false;
            if (length >= segment.getSize()) {
                ByteBuffer buffer = ByteBuffer.allocate(length);
                Intrinsics.checkNotNull((Object)buffer);
                SourcesJvmKt.readAtMostTo((Source)this.source, (ByteBuffer)buffer);
                return buffer;
            }
            SegmentReadContext buffer = ctx;
            void segment$iv = segment;
            boolean $i$f$withData = false;
            byte[] byArray = segment$iv.dataAsByteArray(true);
            int n = segment$iv.getPos();
            segment$iv.getLimit();
            int n2 = n;
            byte[] bytes = byArray;
            boolean bl2 = false;
            this.source.skip((long)length);
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, (int)offset, length).asReadOnlyBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"asReadOnlyBuffer(...)");
            return byteBuffer;
        }
        throw new IllegalStateException("Unreachable".toString());
    }

    public void skipBytes() {
        this.source.skip(this.readLong());
    }

    public void readFixed(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        SourcesKt.readTo$default((Source)this.source, (byte[])bytes, (int)0, (int)0, (int)6, null);
    }

    public void readFixed(@NotNull byte[] bytes, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        SourcesKt.readTo((Source)this.source, (byte[])bytes, (int)start, (int)(start + length));
    }

    public void skipFixed(int length) {
        this.source.skip((long)length);
    }

    public int readEnum() {
        return this.readInt();
    }

    public long readArrayStart() {
        return this.doReadItemCount();
    }

    public long readMapStart() {
        return this.doReadItemCount();
    }

    public long arrayNext() {
        return this.doReadItemCount();
    }

    public long mapNext() {
        return this.doReadItemCount();
    }

    public long skipArray() {
        return this.doSkipItems();
    }

    public long skipMap() {
        return this.doSkipItems();
    }

    private final long doReadItemCount() {
        long result = this.readLong();
        if (result < 0L) {
            this.readLong();
            result = -result;
        }
        return result;
    }

    private final long doSkipItems() {
        long result = this.readLong();
        while (result < 0L) {
            this.source.skip(this.readLong());
            result = this.readLong();
        }
        return result;
    }

    public int readIndex() {
        return this.readInt();
    }
}

