/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.direct;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.encoder.direct.AbstractAvroDirectEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/direct/MapDirectEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/direct/AbstractAvroDirectEncoder;", "schema", "Lorg/apache/avro/Schema;", "mapSize", "", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "binaryEncoder", "Lorg/apache/avro/io/Encoder;", "<init>", "(Lorg/apache/avro/Schema;ILcom/github/avrokotlin/avro4k/Avro;Lorg/apache/avro/io/Encoder;)V", "endStructure", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "encodeElement", "", "index", "Companion", "core"})
public final class MapDirectEncoder
extends AbstractAvroDirectEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Schema schema;
    public Schema currentWriterSchema;
    private static final Schema STRING_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);

    public MapDirectEncoder(@NotNull Schema schema, int mapSize, @NotNull Avro avro, @NotNull Encoder binaryEncoder) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)binaryEncoder, (String)"binaryEncoder");
        super(avro, binaryEncoder, null);
        this.schema = schema;
        binaryEncoder.writeMapStart();
        binaryEncoder.setItemCount((long)mapSize);
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.getBinaryEncoder().writeMapEnd();
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.currentWriterSchema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentWriterSchema");
        return null;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Schema schema;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super.encodeElement(descriptor, index);
        if (index % 2 == 0) {
            this.getBinaryEncoder().startItem();
            schema = STRING_SCHEMA;
        } else {
            schema = this.schema.getValueType();
        }
        Schema schema2 = schema;
        Intrinsics.checkNotNull((Object)schema2);
        this.setCurrentWriterSchema(schema2);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/direct/MapDirectEncoder$Companion;", "", "<init>", "()V", "STRING_SCHEMA", "Lorg/apache/avro/Schema;", "kotlin.jvm.PlatformType", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

