/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.direct;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.encoder.direct.AbstractAvroDirectEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/direct/RecordNonContiguousEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/direct/AbstractAvroDirectEncoder;", "descriptorToWriterFieldIndex", "", "schema", "Lorg/apache/avro/Schema;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "binaryEncoder", "Lorg/apache/avro/io/Encoder;", "<init>", "([ILorg/apache/avro/Schema;Lcom/github/avrokotlin/avro4k/Avro;Lorg/apache/avro/io/Encoder;)V", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "encodeElement", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "core"})
final class RecordNonContiguousEncoder
extends AbstractAvroDirectEncoder {
    @NotNull
    private final int[] descriptorToWriterFieldIndex;
    @NotNull
    private final Schema schema;
    public Schema currentWriterSchema;

    public RecordNonContiguousEncoder(@NotNull int[] descriptorToWriterFieldIndex, @NotNull Schema schema, @NotNull Avro avro, @NotNull Encoder binaryEncoder) {
        Intrinsics.checkNotNullParameter((Object)descriptorToWriterFieldIndex, (String)"descriptorToWriterFieldIndex");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)binaryEncoder, (String)"binaryEncoder");
        super(avro, binaryEncoder, null);
        this.descriptorToWriterFieldIndex = descriptorToWriterFieldIndex;
        this.schema = schema;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.currentWriterSchema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentWriterSchema");
        return null;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int writerFieldIndex = this.descriptorToWriterFieldIndex[index];
        if (writerFieldIndex == -1) {
            return false;
        }
        super.encodeElement(descriptor, index);
        Schema schema = ((Schema.Field)this.schema.getFields().get(writerFieldIndex)).schema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
        this.setCurrentWriterSchema(schema);
        return true;
    }
}

