/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.encoder.AbstractAvroEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.generic.ArrayGenericEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.generic.MapGenericEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.generic.PolymorphicEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.generic.RecordGenericEncoderKt;
import java.nio.ByteBuffer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001eH\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0017H\u0016J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001aH\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010\n\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\n\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\u001fH\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/generic/AbstractAvroGenericEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/AbstractAvroEncoder;", "<init>", "()V", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "getAvro", "()Lcom/github/avrokotlin/avro4k/Avro;", "encodeValue", "", "value", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getRecordEncoder", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getPolymorphicEncoder", "getArrayEncoder", "collectionSize", "", "getMapEncoder", "encodeBytesUnchecked", "", "encodeBooleanUnchecked", "", "encodeStringUnchecked", "Lorg/apache/avro/util/Utf8;", "", "encodeUnionIndexUnchecked", "index", "encodeFixedUnchecked", "encodeIntUnchecked", "encodeLongUnchecked", "", "encodeFloatUnchecked", "", "encodeDoubleUnchecked", "", "encodeEnumUnchecked", "symbol", "core"})
public abstract class AbstractAvroGenericEncoder
extends AbstractAvroEncoder {
    @NotNull
    public abstract Avro getAvro();

    public abstract void encodeValue(@NotNull Object var1);

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getAvro().getSerializersModule();
    }

    @Override
    @NotNull
    public CompositeEncoder getRecordEncoder(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return RecordGenericEncoderKt.RecordGenericEncoder(descriptor, this.getCurrentWriterSchema(), this.getAvro(), (Function1<? super GenericRecord, Unit>)((Function1)arg_0 -> AbstractAvroGenericEncoder.getRecordEncoder$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public CompositeEncoder getPolymorphicEncoder(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (CompositeEncoder)new PolymorphicEncoder(this.getAvro(), this.getCurrentWriterSchema(), (Function1<Object, Unit>)((Function1)arg_0 -> AbstractAvroGenericEncoder.getPolymorphicEncoder$lambda$0(this, arg_0)));
    }

    @Override
    @NotNull
    public CompositeEncoder getArrayEncoder(@NotNull SerialDescriptor descriptor, int collectionSize) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (CompositeEncoder)new ArrayGenericEncoder(this.getAvro(), collectionSize, this.getCurrentWriterSchema(), arg_0 -> AbstractAvroGenericEncoder.getArrayEncoder$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public CompositeEncoder getMapEncoder(@NotNull SerialDescriptor descriptor, int collectionSize) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (CompositeEncoder)new MapGenericEncoder(this.getAvro(), collectionSize, this.getCurrentWriterSchema(), (Function1<? super Map<String, ? extends Object>, Unit>)((Function1)arg_0 -> AbstractAvroGenericEncoder.getMapEncoder$lambda$0(this, arg_0)));
    }

    @Override
    public void encodeBytesUnchecked(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBuffer byteBuffer = ByteBuffer.wrap(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        this.encodeValue(byteBuffer);
    }

    @Override
    public void encodeBooleanUnchecked(boolean value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeStringUnchecked(@NotNull Utf8 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeValue(value);
    }

    @Override
    public void encodeStringUnchecked(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeValue(new Utf8(value));
    }

    @Override
    public void encodeUnionIndexUnchecked(int index) {
    }

    @Override
    public void encodeFixedUnchecked(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeValue(new GenericData.Fixed(this.getCurrentWriterSchema(), value));
    }

    @Override
    public void encodeIntUnchecked(int value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeLongUnchecked(long value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeFloatUnchecked(float value) {
        this.encodeValue(Float.valueOf(value));
    }

    @Override
    public void encodeDoubleUnchecked(double value) {
        this.encodeValue(value);
    }

    @Override
    public void encodeEnumUnchecked(@NotNull String symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.encodeValue(new GenericData.EnumSymbol(this.getCurrentWriterSchema(), symbol));
    }

    private static final Unit getRecordEncoder$lambda$0(AbstractAvroGenericEncoder this$0, GenericRecord it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.encodeValue(it);
        return Unit.INSTANCE;
    }

    private static final Unit getPolymorphicEncoder$lambda$0(AbstractAvroGenericEncoder this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.encodeValue(it);
        return Unit.INSTANCE;
    }

    private static final Unit getArrayEncoder$lambda$0(AbstractAvroGenericEncoder this$0, GenericArray it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.encodeValue(it);
        return Unit.INSTANCE;
    }

    private static final Unit getMapEncoder$lambda$0(AbstractAvroGenericEncoder this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.encodeValue(it);
        return Unit.INSTANCE;
    }
}

