/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.ListRecord;
import com.github.avrokotlin.avro4k.internal.encoder.generic.AbstractAvroGenericEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0010H\u0016J\b\u0010!\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/generic/AbstractRecordGenericEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/generic/AbstractAvroGenericEncoder;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "schema", "Lorg/apache/avro/Schema;", "onEncoded", "Lkotlin/Function1;", "Lorg/apache/avro/generic/GenericRecord;", "", "<init>", "(Lcom/github/avrokotlin/avro4k/Avro;Lorg/apache/avro/Schema;Lkotlin/jvm/functions/Function1;)V", "getAvro", "()Lcom/github/avrokotlin/avro4k/Avro;", "fieldValues", "", "", "[Ljava/lang/Object;", "currentField", "Lorg/apache/avro/Schema$Field;", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "setWriterField", "writerFieldIndex", "", "endStructure", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeValue", "value", "encodeNullUnchecked", "core"})
abstract class AbstractRecordGenericEncoder
extends AbstractAvroGenericEncoder {
    @NotNull
    private final Avro avro;
    @NotNull
    private final Schema schema;
    @NotNull
    private final Function1<GenericRecord, Unit> onEncoded;
    @NotNull
    private final Object[] fieldValues;
    private Schema.Field currentField;
    public Schema currentWriterSchema;

    public AbstractRecordGenericEncoder(@NotNull Avro avro, @NotNull Schema schema, @NotNull Function1<? super GenericRecord, Unit> onEncoded) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(onEncoded, (String)"onEncoded");
        this.avro = avro;
        this.schema = schema;
        this.onEncoded = onEncoded;
        int n = 0;
        int n2 = this.schema.getFields().size();
        Object[] objectArray = new Object[n2];
        AbstractRecordGenericEncoder abstractRecordGenericEncoder = this;
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = null;
        }
        abstractRecordGenericEncoder.fieldValues = objectArray;
    }

    @Override
    @NotNull
    public Avro getAvro() {
        return this.avro;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.currentWriterSchema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentWriterSchema");
        return null;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    protected final void setWriterField(int writerFieldIndex) {
        Schema.Field field = (Schema.Field)this.schema.getFields().get(writerFieldIndex);
        Intrinsics.checkNotNull((Object)field);
        this.currentField = field;
        Schema schema = field.schema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schema(...)");
        this.setCurrentWriterSchema(schema);
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.onEncoded.invoke((Object)new ListRecord(this.schema, ArraysKt.asList((Object[])this.fieldValues)));
    }

    @Override
    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Schema.Field field = this.currentField;
        if (field == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentField");
            field = null;
        }
        this.fieldValues[field.pos()] = value;
    }

    @Override
    public void encodeNullUnchecked() {
        Schema.Field field = this.currentField;
        if (field == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentField");
            field = null;
        }
        this.fieldValues[field.pos()] = null;
    }
}

