/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.encoder.generic.AbstractAvroGenericEncoder;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0007X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/github/avrokotlin/avro4k/internal/encoder/generic/ArrayGenericEncoder;", "Lcom/github/avrokotlin/avro4k/internal/encoder/generic/AbstractAvroGenericEncoder;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "arraySize", "", "schema", "Lorg/apache/avro/Schema;", "onEncoded", "Lkotlin/Function1;", "Lorg/apache/avro/generic/GenericArray;", "", "<init>", "(Lcom/github/avrokotlin/avro4k/Avro;ILorg/apache/avro/Schema;Lkotlin/jvm/functions/Function1;)V", "getAvro", "()Lcom/github/avrokotlin/avro4k/Avro;", "values", "", "", "[Ljava/lang/Object;", "index", "currentWriterSchema", "getCurrentWriterSchema", "()Lorg/apache/avro/Schema;", "setCurrentWriterSchema", "(Lorg/apache/avro/Schema;)V", "encodeElement", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "endStructure", "encodeValue", "value", "encodeNullUnchecked", "core"})
public final class ArrayGenericEncoder
extends AbstractAvroGenericEncoder {
    @NotNull
    private final Avro avro;
    @NotNull
    private final Schema schema;
    @NotNull
    private final Function1<GenericArray<?>, Unit> onEncoded;
    @NotNull
    private final Object[] values;
    private int index;
    public Schema currentWriterSchema;

    public ArrayGenericEncoder(@NotNull Avro avro, int arraySize, @NotNull Schema schema, @NotNull Function1<? super GenericArray<?>, Unit> onEncoded) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(onEncoded, (String)"onEncoded");
        this.avro = avro;
        this.schema = schema;
        this.onEncoded = onEncoded;
        int n = 0;
        Object[] objectArray = new Object[arraySize];
        ArrayGenericEncoder arrayGenericEncoder = this;
        while (n < arraySize) {
            int n2 = n++;
            objectArray[n2] = null;
        }
        arrayGenericEncoder.values = objectArray;
    }

    @Override
    @NotNull
    public Avro getAvro() {
        return this.avro;
    }

    @Override
    @NotNull
    public Schema getCurrentWriterSchema() {
        Schema schema = this.currentWriterSchema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentWriterSchema");
        return null;
    }

    @Override
    public void setCurrentWriterSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"<set-?>");
        this.currentWriterSchema = schema;
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        super.encodeElement(descriptor, index);
        Schema schema = this.schema.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"getElementType(...)");
        this.setCurrentWriterSchema(schema);
        return true;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.onEncoded.invoke((Object)new GenericData.Array(this.schema, (Collection)ArraysKt.asList((Object[])this.values)));
    }

    @Override
    public void encodeValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = this.index;
        this.index = n + 1;
        this.values[n] = value;
    }

    @Override
    public void encodeNullUnchecked() {
        int n = this.index;
        this.index = n + 1;
        this.values[n] = null;
    }
}

