/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.internal.encoder.generic;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.internal.EncodingWorkflow;
import com.github.avrokotlin.avro4k.internal.encoder.generic.RecordContiguousExactEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.generic.RecordContiguousSkippingEncoder;
import com.github.avrokotlin.avro4k.internal.encoder.generic.RecordNonContiguousEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0000\u00a8\u0006\f"}, d2={"RecordGenericEncoder", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "schema", "Lorg/apache/avro/Schema;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "onEncoded", "Lkotlin/Function1;", "Lorg/apache/avro/generic/GenericRecord;", "", "core"})
@SourceDebugExtension(value={"SMAP\nRecordGenericEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordGenericEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/generic/RecordGenericEncoderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n774#2:116\n865#2,2:117\n*S KotlinDebug\n*F\n+ 1 RecordGenericEncoder.kt\ncom/github/avrokotlin/avro4k/internal/encoder/generic/RecordGenericEncoderKt\n*L\n26#1:116\n26#1:117,2\n*E\n"})
public final class RecordGenericEncoderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CompositeEncoder RecordGenericEncoder(@NotNull SerialDescriptor descriptor, @NotNull Schema schema, @NotNull Avro avro, @NotNull Function1<? super GenericRecord, Unit> onEncoded) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter(onEncoded, (String)"onEncoded");
        EncodingWorkflow encodingWorkflow = avro.getRecordResolver$core().resolveFields(schema, descriptor).getEncoding();
        if (encodingWorkflow instanceof EncodingWorkflow.ExactMatch) {
            compositeEncoder = (CompositeEncoder)new RecordContiguousExactEncoder(schema, avro, onEncoded);
        } else if (encodingWorkflow instanceof EncodingWorkflow.ContiguousWithSkips) {
            compositeEncoder = (CompositeEncoder)new RecordContiguousSkippingEncoder(((EncodingWorkflow.ContiguousWithSkips)encodingWorkflow).getFieldsToSkip(), schema, avro, onEncoded);
        } else if (encodingWorkflow instanceof EncodingWorkflow.NonContiguous) {
            compositeEncoder = (CompositeEncoder)new RecordNonContiguousEncoder(((EncodingWorkflow.NonContiguous)encodingWorkflow).getDescriptorToWriterFieldIndex(), schema, avro, onEncoded);
        } else {
            if (encodingWorkflow instanceof EncodingWorkflow.MissingWriterFields) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Missing writer fields ");
                List list = schema.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
                Iterable iterable = list;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean $i$f$filter = false;
                void var7_8 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Schema.Field it = (Schema.Field)element$iv$iv;
                    boolean bl = false;
                    if (!((EncodingWorkflow.MissingWriterFields)encodingWorkflow).getMissingWriterFields().contains(it.pos())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String string = stringBuilder2.append((List)destination$iv$iv).append("} from the descriptor ").append(descriptor).toString();
                throw new SerializationException(string);
            }
            throw new NoWhenBranchMatchedException();
        }
        return compositeEncoder;
    }
}

