/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.serializer;

import com.github.avrokotlin.avro4k.AnyValueDecoder;
import com.github.avrokotlin.avro4k.AvroDecimal;
import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroEncoderKt;
import com.github.avrokotlin.avro4k.AvroFixed;
import com.github.avrokotlin.avro4k.AvroStringable;
import com.github.avrokotlin.avro4k.internal.AvroSchemaGenerationException;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoder;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.AvroSerializerKt;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0018\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\u00020 *\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/github/avrokotlin/avro4k/serializer/BigDecimalSerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "Ljava/math/BigDecimal;", "<init>", "()V", "DECIMAL_LOGICAL_TYPE_NAME", "", "BIG_DECIMAL_LOGICAL_TYPE_NAME", "decimalConverter", "Lorg/apache/avro/Conversion;", "bigDecimalConverter", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "tryGetConverter", "schema", "unsupportedWriterTypeError", "", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "logicalType", "Lorg/apache/avro/LogicalTypes$Decimal;", "Lcom/github/avrokotlin/avro4k/AvroDecimal;", "getLogicalType", "(Lcom/github/avrokotlin/avro4k/AvroDecimal;)Lorg/apache/avro/LogicalTypes$Decimal;", "core"})
@SourceDebugExtension(value={"SMAP\nJavaStdLibSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaStdLibSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/BigDecimalSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AvroDecoder.kt\ncom/github/avrokotlin/avro4k/AvroDecoderKt\n*L\n1#1,369:1\n1#2:370\n104#3:371\n297#3,13:372\n*S KotlinDebug\n*F\n+ 1 JavaStdLibSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/BigDecimalSerializer\n*L\n332#1:371\n332#1:372,13\n*E\n"})
public final class BigDecimalSerializer
extends AvroSerializer<BigDecimal> {
    @NotNull
    public static final BigDecimalSerializer INSTANCE = new BigDecimalSerializer();
    @NotNull
    public static final String DECIMAL_LOGICAL_TYPE_NAME = "decimal";
    @NotNull
    public static final String BIG_DECIMAL_LOGICAL_TYPE_NAME = "big-decimal";
    @NotNull
    private static final Conversion<BigDecimal> decimalConverter = (Conversion)new Conversions.DecimalConversion();
    @NotNull
    private static final Conversion<BigDecimal> bigDecimalConverter = (Conversion)new Conversions.BigDecimalConversion();

    private BigDecimalSerializer() {
        String string = Reflection.getOrCreateKotlinClass(BigDecimal.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        AvroStringable avroStringable;
        AvroStringable avroStringable2;
        LogicalTypes.Decimal decimalLogicalType;
        block8: {
            Object object;
            block7: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                for (Object it : (Iterable)context.getInlinedElements()) {
                    boolean bl = false;
                    if ((it = AvroSerializerKt.getDecimal((ElementLocation)it)) == null) continue;
                    object = it;
                    break block7;
                }
                object = null;
            }
            decimalLogicalType = object != null ? this.getLogicalType((AvroDecimal)object) : null;
            for (Object it : (Iterable)context.getInlinedElements()) {
                AvroStringable avroStringable3;
                boolean bl = false;
                AvroStringable avroStringable4 = AvroSerializerKt.getStringable((ElementLocation)it);
                if (avroStringable4 == null || (avroStringable4 = AvroSerializerKt.createSchema(avroStringable4)) == null) {
                    AvroFixed avroFixed = AvroSerializerKt.getFixed((ElementLocation)it);
                    if (avroFixed != null && (avroFixed = AvroSerializerKt.createSchema(avroFixed, (ElementLocation)it)) != null) {
                        LogicalTypes.Decimal decimal = decimalLogicalType;
                        if (decimal == null) {
                            throw new AvroSchemaGenerationException("BigDecimal requires @" + Reflection.getOrCreateKotlinClass(AvroDecimal.class).getQualifiedName() + " to work with FIXED schemas.");
                        }
                        avroStringable4 = HelpersKt.copy$default((Schema)avroFixed, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, (LogicalType)decimal, null, 49151, null);
                    } else {
                        avroStringable4 = null;
                    }
                }
                if ((avroStringable3 = avroStringable4) == null) continue;
                avroStringable2 = avroStringable3;
                break block8;
            }
            avroStringable2 = avroStringable = null;
        }
        if (avroStringable2 == null) {
            Schema schema = Schema.create((Schema.Type)Schema.Type.BYTES);
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"create(...)");
            LogicalTypes.Decimal decimal = decimalLogicalType;
            avroStringable = HelpersKt.copy$default(schema, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, decimal != null ? (LogicalType)decimal : new LogicalType(BIG_DECIMAL_LOGICAL_TYPE_NAME), null, 49151, null);
        }
        return avroStringable;
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull BigDecimal value) {
        Schema.Type[] typeArray;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AvroEncoder $this$serializeAvro_u24lambda_u240 = encoder;
        boolean bl = false;
        if (!(!$this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().isUnion() || AvroEncoderKt.trySelectLogicalTypeFromUnion($this$serializeAvro_u24lambda_u240, DECIMAL_LOGICAL_TYPE_NAME, typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.FIXED}) || AvroEncoderKt.trySelectLogicalTypeFromUnion($this$serializeAvro_u24lambda_u240, BIG_DECIMAL_LOGICAL_TYPE_NAME, typeArray = new Schema.Type[]{Schema.Type.BYTES}) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.STRING) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.INT) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.LONG) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.FLOAT) || AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.DOUBLE))) {
            throw INSTANCE.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240);
        }
        Schema.Type type = $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Conversion<BigDecimal> conversion = INSTANCE.tryGetConverter($this$serializeAvro_u24lambda_u240.getCurrentWriterSchema());
                if (conversion == null) {
                    throw INSTANCE.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240);
                }
                byte[] byArray = conversion.toBytes((Object)value, $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema(), $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getLogicalType()).array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                $this$serializeAvro_u24lambda_u240.encodeBytes(byArray);
                break;
            }
            case 2: {
                Conversion<BigDecimal> conversion = INSTANCE.tryGetConverter($this$serializeAvro_u24lambda_u240.getCurrentWriterSchema());
                if (conversion == null) {
                    throw INSTANCE.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240);
                }
                byte[] byArray = conversion.toFixed((Object)value, $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema(), $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getLogicalType()).bytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes(...)");
                $this$serializeAvro_u24lambda_u240.encodeFixed(byArray);
                break;
            }
            case 3: {
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$serializeAvro_u24lambda_u240.encodeString(string);
                break;
            }
            case 4: {
                $this$serializeAvro_u24lambda_u240.encodeInt(value.intValueExact());
                break;
            }
            case 5: {
                $this$serializeAvro_u24lambda_u240.encodeLong(value.longValueExact());
                break;
            }
            case 6: {
                $this$serializeAvro_u24lambda_u240.encodeFloat(value.floatValue());
                break;
            }
            case 7: {
                $this$serializeAvro_u24lambda_u240.encodeDouble(value.doubleValue());
                break;
            }
            default: {
                throw INSTANCE.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240);
            }
        }
    }

    private final Conversion<BigDecimal> tryGetConverter(Schema schema) {
        String string = schema.getProp("logicalType");
        return Intrinsics.areEqual((Object)string, (Object)DECIMAL_LOGICAL_TYPE_NAME) ? decimalConverter : (Intrinsics.areEqual((Object)string, (Object)BIG_DECIMAL_LOGICAL_TYPE_NAME) ? bigDecimalConverter : null);
    }

    private final Throwable unsupportedWriterTypeError(AvroEncoder $this$unsupportedWriterTypeError) {
        Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.FIXED, Schema.Type.STRING, Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE};
        return AvroEncoderKt.unsupportedWriterTypeError($this$unsupportedWriterTypeError, Schema.Type.BYTES, typeArray);
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    @Override
    @NotNull
    public BigDecimal deserializeAvro(@NotNull AvroDecoder decoder) {
        AnyValueDecoder<BigDecimal> foundResolver$iv$iv;
        AnyValueDecoder<BigDecimal> anyValueDecoder;
        AvroDecoder $this$decodeResolvingAny$iv;
        AvroDecoder $this$deserializeAvro_u24lambda_u240;
        block19: {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            $this$deserializeAvro_u24lambda_u240 = decoder;
            boolean bl = false;
            $this$decodeResolvingAny$iv = $this$deserializeAvro_u24lambda_u240;
            boolean $i$f$decodeResolvingAny = false;
            AvroDecoder $this$findValueDecoder$iv$iv = $this$decodeResolvingAny$iv;
            boolean $i$f$findValueDecoder = false;
            Schema schema$iv$iv = $this$findValueDecoder$iv$iv.getCurrentWriterSchema();
            if (schema$iv$iv.isUnion()) {
                if ($this$findValueDecoder$iv$iv instanceof AbstractAvroDirectDecoder) {
                    throw new UnsupportedOperationException("The union should be already resolved, which means a misusage of avro4k");
                }
                List list = $this$findValueDecoder$iv$iv.getCurrentWriterSchema().getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
                for (Schema schema : (Iterable)list) {
                    AnyValueDecoder<BigDecimal> anyValueDecoder2;
                    AnyValueDecoder<BigDecimal> anyValueDecoder3;
                    boolean bl2 = false;
                    Schema.Type type = schema.getType();
                    switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 3: {
                            anyValueDecoder3 = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$0$1$0(decoder, arg_0);
                            break;
                        }
                        case 1: {
                            Conversion<BigDecimal> it;
                            if (INSTANCE.tryGetConverter(schema) != null) {
                                boolean bl3 = false;
                                anyValueDecoder3 = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$0$1$1$0(it, decoder, schema, arg_0);
                                break;
                            }
                            anyValueDecoder3 = null;
                            break;
                        }
                        case 2: {
                            Conversion<BigDecimal> it;
                            if (INSTANCE.tryGetConverter(schema) != null) {
                                boolean bl4 = false;
                                anyValueDecoder3 = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$0$1$2$0(it, decoder, schema, arg_0);
                                break;
                            }
                            anyValueDecoder3 = null;
                            break;
                        }
                        default: {
                            anyValueDecoder3 = null;
                        }
                    }
                    if ((anyValueDecoder2 = anyValueDecoder3) == null) continue;
                    anyValueDecoder = anyValueDecoder2;
                    break block19;
                }
                anyValueDecoder = null;
            } else {
                Schema schema = schema$iv$iv;
                boolean bl5 = false;
                Schema.Type type = schema.getType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 3: {
                        anyValueDecoder = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$0$1$0(decoder, arg_0);
                        break;
                    }
                    case 1: {
                        Conversion<BigDecimal> it;
                        Conversion<BigDecimal> conversion = INSTANCE.tryGetConverter(schema);
                        if (conversion != null) {
                            it = conversion;
                            boolean bl6 = false;
                            anyValueDecoder = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$0$1$1$0(it, decoder, schema, arg_0);
                            break;
                        }
                        anyValueDecoder = null;
                        break;
                    }
                    case 2: {
                        Conversion<BigDecimal> it;
                        Conversion<BigDecimal> conversion = INSTANCE.tryGetConverter(schema);
                        if (conversion != null) {
                            it = conversion;
                            boolean bl7 = false;
                            anyValueDecoder = arg_0 -> BigDecimalSerializer.deserializeAvro$lambda$0$1$2$0(it, decoder, schema, arg_0);
                            break;
                        }
                        anyValueDecoder = null;
                        break;
                    }
                    default: {
                        anyValueDecoder = null;
                    }
                }
            }
        }
        AnyValueDecoder<BigDecimal> anyValueDecoder4 = foundResolver$iv$iv = anyValueDecoder;
        if (anyValueDecoder4 == null) {
            boolean bl = false;
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.BYTES, Schema.Type.FIXED};
            throw (Throwable)ExceptionsKt.UnexpectedDecodeSchemaError($this$deserializeAvro_u24lambda_u240, "BigDecimal", Schema.Type.STRING, typeArray);
        }
        return anyValueDecoder4.decodeAny($this$decodeResolvingAny$iv);
    }

    @Override
    @NotNull
    public BigDecimal deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        return new BigDecimal(decoder.decodeString());
    }

    private final LogicalTypes.Decimal getLogicalType(AvroDecimal $this$logicalType) {
        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)$this$logicalType.precision(), (int)$this$logicalType.scale());
        Intrinsics.checkNotNullExpressionValue((Object)decimal, (String)"decimal(...)");
        return decimal;
    }

    private static final BigDecimal deserializeAvro$lambda$0$1$0(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return new BigDecimal($decoder.decodeString());
    }

    private static final BigDecimal deserializeAvro$lambda$0$1$1$0(Conversion $it, AvroDecoder $decoder, Schema $schema, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Object object = $it.fromBytes(ByteBuffer.wrap($decoder.decodeBytes()), $schema, $schema.getLogicalType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromBytes(...)");
        return (BigDecimal)object;
    }

    private static final BigDecimal deserializeAvro$lambda$0$1$2$0(Conversion $it, AvroDecoder $decoder, Schema $schema, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Object object = $it.fromFixed($decoder.decodeFixed(), $schema, $schema.getLogicalType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromFixed(...)");
        return (BigDecimal)object;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FIXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.LONG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

