/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.serializer;

import com.github.avrokotlin.avro4k.AnyValueDecoder;
import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroEncoderKt;
import com.github.avrokotlin.avro4k.AvroStringable;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoder;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.AvroSerializerKt;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import com.github.avrokotlin.avro4k.serializer.JavaTimeSerializersKt;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/github/avrokotlin/avro4k/serializer/LocalDateTimeSerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "Ljava/time/LocalDateTime;", "<init>", "()V", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "core"})
@SourceDebugExtension(value={"SMAP\nJavaTimeSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaTimeSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/LocalDateTimeSerializer\n+ 2 AvroDecoder.kt\ncom/github/avrokotlin/avro4k/AvroDecoderKt\n*L\n1#1,545:1\n104#2:546\n297#2,13:547\n*S KotlinDebug\n*F\n+ 1 JavaTimeSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/LocalDateTimeSerializer\n*L\n263#1:546\n263#1:547,13\n*E\n"})
public final class LocalDateTimeSerializer
extends AvroSerializer<LocalDateTime> {
    @NotNull
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    private LocalDateTimeSerializer() {
        String string = Reflection.getOrCreateKotlinClass(LocalDateTime.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        Schema schema;
        Schema schema2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            for (ElementLocation it : (Iterable)context.getInlinedElements()) {
                boolean bl = false;
                AvroStringable avroStringable = AvroSerializerKt.getStringable(it);
                Object object = avroStringable != null ? AvroSerializerKt.createSchema(avroStringable) : null;
                if (object == null) continue;
                schema2 = object;
                break block2;
            }
            schema2 = schema = null;
        }
        if (schema2 == null) {
            Schema schema3 = Schema.create((Schema.Type)Schema.Type.LONG);
            Intrinsics.checkNotNullExpressionValue((Object)schema3, (String)"create(...)");
            schema = HelpersKt.copy$default(schema3, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, new LogicalType("timestamp-millis"), null, 49151, null);
        }
        return schema;
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull LocalDateTime value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AvroEncoder $this$serializeAvro_u24lambda_u240 = encoder;
        boolean bl = false;
        if ($this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.LONG) && !AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.STRING)) {
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
            throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240, Schema.Type.LONG, typeArray);
        }
        Schema.Type type = $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                String string;
                LogicalType logicalType = $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getLogicalType();
                String string2 = string = logicalType != null ? logicalType.getName() : null;
                if (Intrinsics.areEqual((Object)string, (Object)"timestamp-micros")) {
                    Instant instant = value.toInstant(ZoneOffset.UTC);
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
                    $this$serializeAvro_u24lambda_u240.encodeLong(JavaTimeSerializersKt.access$toEpochMicros(instant));
                    break;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"timestamp-millis")) {
                    $this$serializeAvro_u24lambda_u240.encodeLong(value.toInstant(ZoneOffset.UTC).toEpochMilli());
                    break;
                }
                throw AvroEncoderKt.logicalTypeMismatchError($this$serializeAvro_u24lambda_u240, "timestamp-millis", Schema.Type.LONG);
            }
            case 2: {
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$serializeAvro_u24lambda_u240.encodeString(string);
                break;
            }
            default: {
                Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.STRING};
                throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240, Schema.Type.LONG, typeArray);
            }
        }
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull LocalDateTime value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    @Override
    @NotNull
    public LocalDateTime deserializeAvro(@NotNull AvroDecoder decoder) {
        AnyValueDecoder<LocalDateTime> foundResolver$iv$iv;
        AnyValueDecoder<LocalDateTime> anyValueDecoder;
        AvroDecoder $this$decodeResolvingAny$iv;
        AvroDecoder $this$deserializeAvro_u24lambda_u240;
        block17: {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            $this$deserializeAvro_u24lambda_u240 = decoder;
            boolean bl = false;
            $this$decodeResolvingAny$iv = $this$deserializeAvro_u24lambda_u240;
            boolean $i$f$decodeResolvingAny = false;
            AvroDecoder $this$findValueDecoder$iv$iv = $this$decodeResolvingAny$iv;
            boolean $i$f$findValueDecoder = false;
            Schema schema$iv$iv = $this$findValueDecoder$iv$iv.getCurrentWriterSchema();
            if (schema$iv$iv.isUnion()) {
                if ($this$findValueDecoder$iv$iv instanceof AbstractAvroDirectDecoder) {
                    throw new UnsupportedOperationException("The union should be already resolved, which means a misusage of avro4k");
                }
                List list = $this$findValueDecoder$iv$iv.getCurrentWriterSchema().getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
                for (Schema it : (Iterable)list) {
                    AnyValueDecoder<LocalDateTime> anyValueDecoder2;
                    AnyValueDecoder<LocalDateTime> anyValueDecoder3;
                    boolean bl2 = false;
                    Schema.Type type = it.getType();
                    switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            String string;
                            LogicalType logicalType = it.getLogicalType();
                            String string2 = string = logicalType != null ? logicalType.getName() : null;
                            if (Intrinsics.areEqual((Object)string, (Object)"timestamp-millis") || string == null) {
                                anyValueDecoder3 = arg_0 -> LocalDateTimeSerializer.deserializeAvro$lambda$0$1$0(decoder, arg_0);
                                break;
                            }
                            if (Intrinsics.areEqual((Object)string, (Object)"timestamp-micros")) {
                                anyValueDecoder3 = arg_0 -> LocalDateTimeSerializer.deserializeAvro$lambda$0$1$1(decoder, arg_0);
                                break;
                            }
                            anyValueDecoder3 = null;
                            break;
                        }
                        case 2: {
                            anyValueDecoder3 = arg_0 -> LocalDateTimeSerializer.deserializeAvro$lambda$0$1$2(decoder, arg_0);
                            break;
                        }
                        default: {
                            anyValueDecoder3 = null;
                        }
                    }
                    if ((anyValueDecoder2 = anyValueDecoder3) == null) continue;
                    anyValueDecoder = anyValueDecoder2;
                    break block17;
                }
                anyValueDecoder = null;
            } else {
                Schema it = schema$iv$iv;
                boolean bl3 = false;
                Schema.Type type = it.getType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        String string;
                        LogicalType logicalType = it.getLogicalType();
                        String string3 = string = logicalType != null ? logicalType.getName() : null;
                        if (Intrinsics.areEqual((Object)string, (Object)"timestamp-millis") || string == null) {
                            anyValueDecoder = arg_0 -> LocalDateTimeSerializer.deserializeAvro$lambda$0$1$0(decoder, arg_0);
                            break;
                        }
                        if (Intrinsics.areEqual((Object)string, (Object)"timestamp-micros")) {
                            anyValueDecoder = arg_0 -> LocalDateTimeSerializer.deserializeAvro$lambda$0$1$1(decoder, arg_0);
                            break;
                        }
                        anyValueDecoder = null;
                        break;
                    }
                    case 2: {
                        anyValueDecoder = arg_0 -> LocalDateTimeSerializer.deserializeAvro$lambda$0$1$2(decoder, arg_0);
                        break;
                    }
                    default: {
                        anyValueDecoder = null;
                    }
                }
            }
        }
        AnyValueDecoder<LocalDateTime> anyValueDecoder4 = foundResolver$iv$iv = anyValueDecoder;
        if (anyValueDecoder4 == null) {
            boolean bl = false;
            throw (Throwable)ExceptionsKt.UnexpectedDecodeSchemaError($this$deserializeAvro_u24lambda_u240, "Instant", Schema.Type.LONG, new Schema.Type[0]);
        }
        LocalDateTime localDateTime = anyValueDecoder4.decodeAny($this$decodeResolvingAny$iv);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"with(...)");
        return localDateTime;
    }

    @Override
    @NotNull
    public LocalDateTime deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        LocalDateTime localDateTime = LocalDateTime.parse(decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(...)");
        return localDateTime;
    }

    private static final LocalDateTime deserializeAvro$lambda$0$1$0(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return LocalDateTime.ofInstant(Instant.ofEpochMilli($decoder.decodeLong()), ZoneOffset.UTC);
    }

    private static final LocalDateTime deserializeAvro$lambda$0$1$1(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return LocalDateTime.ofInstant(Instant.EPOCH.plus($decoder.decodeLong(), ChronoUnit.MICROS), ZoneOffset.UTC);
    }

    private static final LocalDateTime deserializeAvro$lambda$0$1$2(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return LocalDateTime.parse($decoder.decodeString());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.LONG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

