/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.serializer;

import com.github.avrokotlin.avro4k.AnyValueDecoder;
import com.github.avrokotlin.avro4k.AvroDecoder;
import com.github.avrokotlin.avro4k.AvroEncoder;
import com.github.avrokotlin.avro4k.AvroEncoderKt;
import com.github.avrokotlin.avro4k.AvroFixed;
import com.github.avrokotlin.avro4k.AvroStringable;
import com.github.avrokotlin.avro4k.internal.ExceptionsKt;
import com.github.avrokotlin.avro4k.internal.HelpersKt;
import com.github.avrokotlin.avro4k.internal.decoder.direct.AbstractAvroDirectDecoder;
import com.github.avrokotlin.avro4k.serializer.AvroSerializer;
import com.github.avrokotlin.avro4k.serializer.AvroSerializerKt;
import com.github.avrokotlin.avro4k.serializer.ElementLocation;
import com.github.avrokotlin.avro4k.serializer.SchemaSupplierContext;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/avrokotlin/avro4k/serializer/UUIDSerializer;", "Lcom/github/avrokotlin/avro4k/serializer/AvroSerializer;", "Ljava/util/UUID;", "<init>", "()V", "LOGICAL_TYPE_NAME", "", "getSchema", "Lorg/apache/avro/Schema;", "context", "Lcom/github/avrokotlin/avro4k/serializer/SchemaSupplierContext;", "serializeAvro", "", "encoder", "Lcom/github/avrokotlin/avro4k/AvroEncoder;", "value", "toByteArray", "", "serializeGeneric", "Lkotlinx/serialization/encoding/Encoder;", "deserializeAvro", "decoder", "Lcom/github/avrokotlin/avro4k/AvroDecoder;", "parseUuid", "bytes", "deserializeGeneric", "Lkotlinx/serialization/encoding/Decoder;", "core"})
@SourceDebugExtension(value={"SMAP\nJavaStdLibSerializers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaStdLibSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/UUIDSerializer\n+ 2 AvroDecoder.kt\ncom/github/avrokotlin/avro4k/AvroDecoderKt\n*L\n1#1,369:1\n104#2:370\n297#2,13:371\n*S KotlinDebug\n*F\n+ 1 JavaStdLibSerializers.kt\ncom/github/avrokotlin/avro4k/serializer/UUIDSerializer\n*L\n115#1:370\n115#1:371,13\n*E\n"})
public final class UUIDSerializer
extends AvroSerializer<UUID> {
    @NotNull
    public static final UUIDSerializer INSTANCE = new UUIDSerializer();
    @NotNull
    public static final String LOGICAL_TYPE_NAME = "uuid";

    private UUIDSerializer() {
        String string = Reflection.getOrCreateKotlinClass(UUID.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        super(string);
    }

    @Override
    @NotNull
    public Schema getSchema(@NotNull SchemaSupplierContext context) {
        AvroStringable avroStringable;
        AvroStringable avroStringable2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            for (ElementLocation element : (Iterable)context.getInlinedElements()) {
                AvroStringable avroStringable3;
                boolean bl = false;
                AvroStringable avroStringable4 = AvroSerializerKt.getStringable(element);
                if (avroStringable4 == null || (avroStringable4 = AvroSerializerKt.createSchema(avroStringable4)) == null) {
                    Schema schema;
                    Schema schema2;
                    AvroFixed avroFixed = AvroSerializerKt.getFixed(element);
                    if (avroFixed != null && (schema2 = AvroSerializerKt.createSchema(avroFixed, element)) != null && (schema = HelpersKt.copy$default(schema2, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, new LogicalType(LOGICAL_TYPE_NAME), null, 49151, null)) != null) {
                        Schema schema3;
                        Schema it = schema3 = schema;
                        boolean bl2 = false;
                        if (it.getFixedSize() != 16) {
                            throw new SerializationException("UUID's @" + Reflection.getOrCreateKotlinClass(AvroFixed.class).getSimpleName() + " must have bytes size of 16. Got " + it.getFixedSize() + '.');
                        }
                        avroStringable4 = schema3;
                    } else {
                        avroStringable4 = null;
                    }
                }
                if ((avroStringable3 = avroStringable4) == null) continue;
                avroStringable2 = avroStringable3;
                break block6;
            }
            avroStringable2 = avroStringable = null;
        }
        if (avroStringable2 == null) {
            Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"create(...)");
            avroStringable = HelpersKt.copy$default(schema, null, null, null, null, false, null, null, null, null, 0, null, null, null, null, new LogicalType(LOGICAL_TYPE_NAME), null, 49151, null);
        }
        return avroStringable;
    }

    @Override
    public void serializeAvro(@NotNull AvroEncoder encoder, @NotNull UUID value) {
        Schema.Type[] typeArray;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        AvroEncoder $this$serializeAvro_u24lambda_u240 = encoder;
        boolean bl = false;
        if ($this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().isUnion() && !AvroEncoderKt.trySelectLogicalTypeFromUnion($this$serializeAvro_u24lambda_u240, LOGICAL_TYPE_NAME, typeArray = new Schema.Type[]{Schema.Type.FIXED}) && !AvroEncoderKt.trySelectTypeNameFromUnion($this$serializeAvro_u24lambda_u240, Schema.Type.STRING) && !AvroEncoderKt.trySelectFixedSchemaForSize($this$serializeAvro_u24lambda_u240, 16)) {
            typeArray = new Schema.Type[]{Schema.Type.FIXED};
            throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240, Schema.Type.STRING, typeArray);
        }
        Schema.Type type = $this$serializeAvro_u24lambda_u240.getCurrentWriterSchema().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$serializeAvro_u24lambda_u240.encodeString(string);
                break;
            }
            case 2: {
                $this$serializeAvro_u24lambda_u240.encodeFixed(INSTANCE.toByteArray(value));
                break;
            }
            default: {
                Schema.Type[] typeArray2 = new Schema.Type[]{Schema.Type.FIXED};
                throw AvroEncoderKt.unsupportedWriterTypeError($this$serializeAvro_u24lambda_u240, Schema.Type.STRING, typeArray2);
            }
        }
    }

    private final byte[] toByteArray(UUID $this$toByteArray) {
        byte[] byArray = ByteBuffer.allocate(16).putLong($this$toByteArray.getMostSignificantBits()).putLong($this$toByteArray.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }

    @Override
    public void serializeGeneric(@NotNull Encoder encoder, @NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }

    @Override
    @NotNull
    public UUID deserializeAvro(@NotNull AvroDecoder decoder) {
        AnyValueDecoder<UUID> foundResolver$iv$iv;
        AnyValueDecoder<UUID> anyValueDecoder;
        AvroDecoder $this$decodeResolvingAny$iv;
        AvroDecoder $this$deserializeAvro_u24lambda_u240;
        block15: {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            $this$deserializeAvro_u24lambda_u240 = decoder;
            boolean bl = false;
            $this$decodeResolvingAny$iv = $this$deserializeAvro_u24lambda_u240;
            boolean $i$f$decodeResolvingAny = false;
            AvroDecoder $this$findValueDecoder$iv$iv = $this$decodeResolvingAny$iv;
            boolean $i$f$findValueDecoder = false;
            Schema schema$iv$iv = $this$findValueDecoder$iv$iv.getCurrentWriterSchema();
            if (schema$iv$iv.isUnion()) {
                if ($this$findValueDecoder$iv$iv instanceof AbstractAvroDirectDecoder) {
                    throw new UnsupportedOperationException("The union should be already resolved, which means a misusage of avro4k");
                }
                List list = $this$findValueDecoder$iv$iv.getCurrentWriterSchema().getTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypes(...)");
                for (Schema schema : (Iterable)list) {
                    AnyValueDecoder<UUID> anyValueDecoder2;
                    AnyValueDecoder<UUID> anyValueDecoder3;
                    boolean bl2 = false;
                    Schema.Type type = schema.getType();
                    switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: {
                            anyValueDecoder3 = arg_0 -> UUIDSerializer.deserializeAvro$lambda$0$1$0(decoder, arg_0);
                            break;
                        }
                        case 2: {
                            if (schema.getFixedSize() == 16) {
                                anyValueDecoder3 = arg_0 -> UUIDSerializer.deserializeAvro$lambda$0$1$1(decoder, arg_0);
                                break;
                            }
                            anyValueDecoder3 = null;
                            break;
                        }
                        default: {
                            anyValueDecoder3 = null;
                        }
                    }
                    if ((anyValueDecoder2 = anyValueDecoder3) == null) continue;
                    anyValueDecoder = anyValueDecoder2;
                    break block15;
                }
                anyValueDecoder = null;
            } else {
                Schema schema = schema$iv$iv;
                boolean bl3 = false;
                Schema.Type type = schema.getType();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        anyValueDecoder = arg_0 -> UUIDSerializer.deserializeAvro$lambda$0$1$0(decoder, arg_0);
                        break;
                    }
                    case 2: {
                        if (schema.getFixedSize() == 16) {
                            anyValueDecoder = arg_0 -> UUIDSerializer.deserializeAvro$lambda$0$1$1(decoder, arg_0);
                            break;
                        }
                        anyValueDecoder = null;
                        break;
                    }
                    default: {
                        anyValueDecoder = null;
                    }
                }
            }
        }
        AnyValueDecoder<UUID> anyValueDecoder4 = foundResolver$iv$iv = anyValueDecoder;
        if (anyValueDecoder4 == null) {
            boolean bl = false;
            Schema.Type[] typeArray = new Schema.Type[]{Schema.Type.FIXED};
            throw (Throwable)ExceptionsKt.UnexpectedDecodeSchemaError($this$deserializeAvro_u24lambda_u240, "UUID", Schema.Type.STRING, typeArray);
        }
        return anyValueDecoder4.decodeAny($this$decodeResolvingAny$iv);
    }

    private final UUID parseUuid(byte[] bytes) {
        ByteBuffer it = ByteBuffer.wrap(bytes);
        boolean bl = false;
        return new UUID(it.getLong(), it.getLong());
    }

    @Override
    @NotNull
    public UUID deserializeGeneric(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        UUID uUID = UUID.fromString(decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return uUID;
    }

    private static final UUID deserializeAvro$lambda$0$1$0(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        UUID uUID = UUID.fromString($decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return uUID;
    }

    private static final UUID deserializeAvro$lambda$0$1$1(AvroDecoder $decoder, AvroDecoder $context_receiver_0) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        return INSTANCE.parseUuid($decoder.decodeBytes());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FIXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

