/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.avrokotlin.avro4k.AvroAlias;
import com.github.avrokotlin.avro4k.AvroConfiguration;
import com.github.avrokotlin.avro4k.AvroDecimal;
import com.github.avrokotlin.avro4k.AvroDefault;
import com.github.avrokotlin.avro4k.AvroDoc;
import com.github.avrokotlin.avro4k.AvroFixed;
import com.github.avrokotlin.avro4k.AvroProp;
import com.github.avrokotlin.avro4k.KotlinPoetHelpersKt;
import com.github.avrokotlin.avro4k.TypeSafeSchema;
import com.github.avrokotlin.avro4k.TypeSafeSchemaKt;
import com.github.avrokotlin.avro4k.WithAliases;
import com.github.avrokotlin.avro4k.WithDoc;
import com.github.avrokotlin.avro4k.WithProps;
import com.github.avrokotlin.avro4k.internal.AvroGenerated;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.apache.avro.util.internal.JacksonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\tH\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\rH\u0002\u001a\f\u0010\u0011\u001a\u00020\r*\u00020\u0010H\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0018H\u0000\u00a8\u0006\u0019\u00b2\u0006\f\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u008a\u0084\u0002\u00b2\u0006\f\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u008a\u0084\u0002"}, d2={"buildAvroFixedAnnotation", "Lcom/squareup/kotlinpoet/AnnotationSpec;", "schema", "Lcom/github/avrokotlin/avro4k/TypeSafeSchema;", "buildAvroPropAnnotations", "", "carrier", "Lcom/github/avrokotlin/avro4k/WithProps;", "buildAvroAliasAnnotation", "Lcom/github/avrokotlin/avro4k/WithAliases;", "buildAvroDecimalAnnotation", "buildAvroGeneratedAnnotation", "schemaStr", "", "buildAvroDefaultAnnotation", "field", "Lcom/github/avrokotlin/avro4k/TypeSafeSchema$NamedSchema$RecordSchema$Field;", "unquotedDefaultValue", "buildImplicitAvroDefaultAnnotation", "configuration", "Lcom/github/avrokotlin/avro4k/AvroConfiguration;", "buildImplicitAvroDefaultCodeBlock", "Lcom/squareup/kotlinpoet/CodeBlock;", "buildAvroDocAnnotation", "Lcom/github/avrokotlin/avro4k/WithDoc;", "kotlin-generator", "scale", "", "precision"})
@SourceDebugExtension(value={"SMAP\nAnnotationsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationsHelper.kt\ncom/github/avrokotlin/avro4k/AnnotationsHelperKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n216#2,2:120\n1869#3,2:122\n*S KotlinDebug\n*F\n+ 1 AnnotationsHelper.kt\ncom/github/avrokotlin/avro4k/AnnotationsHelperKt\n*L\n20#1:120,2\n34#1:122,2\n*E\n"})
public final class AnnotationsHelperKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

    @Nullable
    public static final AnnotationSpec buildAvroFixedAnnotation(@NotNull TypeSafeSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (!(schema instanceof TypeSafeSchema.NamedSchema.FixedSchema)) {
            return null;
        }
        Object[] objectArray = new Object[]{UInt.box-impl((int)((TypeSafeSchema.NamedSchema.FixedSchema)schema).getSize-pVg5ArA())};
        return AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(AvroFixed.class))).addMember(CodeBlock.Companion.of("size = %L", objectArray)).build();
    }

    @NotNull
    public static final List<AnnotationSpec> buildAvroPropAnnotations(@NotNull WithProps carrier) {
        List list;
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        List $this$buildAvroPropAnnotations_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Map<String, Object> $this$forEach$iv = carrier.getProps();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            Object[] objectArray = new Object[]{key, String.valueOf(value)};
            $this$buildAvroPropAnnotations_u24lambda_u241.add(AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(AvroProp.class))).addMember(CodeBlock.Companion.of("%S, %S", objectArray)).build());
        }
        return CollectionsKt.build((List)list);
    }

    @Nullable
    public static final AnnotationSpec buildAvroAliasAnnotation(@NotNull WithAliases carrier) {
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        if (!((Collection)carrier.getAliases()).isEmpty()) {
            AnnotationSpec.Builder builder;
            AnnotationSpec.Builder $this$buildAvroAliasAnnotation_u24lambda_u243 = builder = AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(AvroAlias.class)));
            boolean bl = false;
            Iterable $this$forEach$iv = carrier.getAliases();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String alias = (String)element$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{alias};
                $this$buildAvroAliasAnnotation_u24lambda_u243.addMember(CodeBlock.Companion.of("%S", objectArray));
            }
            return builder.build();
        }
        return null;
    }

    @Nullable
    public static final AnnotationSpec buildAvroDecimalAnnotation(@NotNull TypeSafeSchema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (!(schema instanceof TypeSafeSchema.NamedSchema.FixedSchema) || !Intrinsics.areEqual((Object)TypeSafeSchemaKt.getLogicalTypeName(schema), (Object)"decimal")) {
            return null;
        }
        Map<String, Object> scale$delegate = ((TypeSafeSchema.NamedSchema.FixedSchema)schema).getProps();
        Map<String, Object> precision$delegate = ((TypeSafeSchema.NamedSchema.FixedSchema)schema).getProps();
        Integer n = AnnotationsHelperKt.buildAvroDecimalAnnotation$lambda$5(precision$delegate);
        if (n == null) {
            throw new IllegalStateException(("Missing 'precision' prop for 'decimal' logical type of schema " + schema).toString());
        }
        n.intValue();
        Object[] objectArray = new Object[1];
        Integer n2 = AnnotationsHelperKt.buildAvroDecimalAnnotation$lambda$4(scale$delegate);
        objectArray[0] = n2 != null ? n2 : 0;
        AnnotationSpec.Builder builder = AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(AvroDecimal.class))).addMember(CodeBlock.Companion.of("scale = %L", objectArray));
        objectArray = new Object[]{AnnotationsHelperKt.buildAvroDecimalAnnotation$lambda$5(precision$delegate)};
        return builder.addMember(CodeBlock.Companion.of("precision = %L", objectArray)).build();
    }

    @NotNull
    public static final AnnotationSpec buildAvroGeneratedAnnotation(@NotNull String schemaStr) {
        Intrinsics.checkNotNullParameter((Object)schemaStr, (String)"schemaStr");
        Object[] objectArray = new Object[]{schemaStr};
        return AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(AvroGenerated.class))).addMember("%P", objectArray).build();
    }

    @Nullable
    public static final AnnotationSpec buildAvroDefaultAnnotation(@NotNull TypeSafeSchema.NamedSchema.RecordSchema.Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (!field.hasDefaultValue()) {
            return null;
        }
        return AnnotationsHelperKt.buildAvroDefaultAnnotation(AnnotationsHelperKt.unquotedDefaultValue(field));
    }

    private static final AnnotationSpec buildAvroDefaultAnnotation(String unquotedDefaultValue) {
        Object[] objectArray = new Object[]{unquotedDefaultValue};
        return AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(AvroDefault.class))).addMember("%S", objectArray).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String unquotedDefaultValue(TypeSafeSchema.NamedSchema.RecordSchema.Field $this$unquotedDefaultValue) {
        JsonNode jsonNode = JacksonUtils.toJsonNode((Object)$this$unquotedDefaultValue.getDefaultValue());
        if (jsonNode == null) return "null";
        JsonNode it = jsonNode;
        boolean bl = false;
        String string = it.isTextual() ? it.asText() : it.toString();
        if (string == null) return "null";
        String string2 = string;
        return string2;
    }

    @Nullable
    public static final AnnotationSpec buildImplicitAvroDefaultAnnotation(@NotNull TypeSafeSchema schema, @NotNull AvroConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (configuration.getImplicitNulls() && schema.isNullable()) {
            return AnnotationsHelperKt.buildAvroDefaultAnnotation("null");
        }
        if (configuration.getImplicitEmptyCollections()) {
            if (schema instanceof TypeSafeSchema.CollectionSchema.ArraySchema) {
                return AnnotationsHelperKt.buildAvroDefaultAnnotation("[]");
            }
            if (schema instanceof TypeSafeSchema.CollectionSchema.MapSchema) {
                return AnnotationsHelperKt.buildAvroDefaultAnnotation("{}");
            }
        }
        return null;
    }

    @Nullable
    public static final CodeBlock buildImplicitAvroDefaultCodeBlock(@NotNull TypeSafeSchema schema, @NotNull AvroConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (configuration.getImplicitNulls() && schema.isNullable()) {
            return CodeBlock.Companion.of("null", new Object[0]);
        }
        if (configuration.getImplicitEmptyCollections()) {
            if (schema instanceof TypeSafeSchema.CollectionSchema.ArraySchema) {
                return KotlinPoetHelpersKt.getListOfCodeBlock(CollectionsKt.emptyList());
            }
            if (schema instanceof TypeSafeSchema.CollectionSchema.MapSchema) {
                return KotlinPoetHelpersKt.getMapOfCodeBlock(MapsKt.emptyMap());
            }
        }
        return null;
    }

    @Nullable
    public static final AnnotationSpec buildAvroDocAnnotation(@NotNull WithDoc carrier) {
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        if (carrier.getDoc() != null) {
            Object[] objectArray = new Object[]{carrier.getDoc()};
            return AnnotationSpec.Companion.builder(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(AvroDoc.class))).addMember(CodeBlock.Companion.of("%S", objectArray)).build();
        }
        return null;
    }

    private static final Integer buildAvroDecimalAnnotation$lambda$4(Map<String, ? extends Object> $scale$delegate) {
        Map<String, ? extends Object> map = $scale$delegate;
        return (Integer)MapsKt.getOrImplicitDefaultNullable(map, (Object)$$delegatedProperties[0].getName());
    }

    private static final Integer buildAvroDecimalAnnotation$lambda$5(Map<String, ? extends Object> $precision$delegate) {
        Map<String, ? extends Object> map = $precision$delegate;
        return (Integer)MapsKt.getOrImplicitDefaultNullable(map, (Object)$$delegatedProperties[1].getName());
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(AnnotationsHelperKt.class, "scale", "<v#0>", 1))), Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(AnnotationsHelperKt.class, "precision", "<v#1>", 1)))};
        $$delegatedProperties = kPropertyArray;
    }
}

