/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing;

import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimber;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.gradient.Adam;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.gradient.AmsGrad;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.gradient.Nadam;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.gradient.Stochastic;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.hill.SimpleClimber;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.hill.SimulatedAnnealingClimber;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.inference.IndicatorClimber;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.sim.MiniSimClimber;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.function.Function;

enum HillClimberType {
    SIMPLE(SimpleClimber::new),
    SIMULATED_ANNEALING(SimulatedAnnealingClimber::new),
    STOCHASTIC_GRADIENT_DESCENT(Stochastic::new),
    AMSGRAD(AmsGrad::new),
    NADAM(Nadam::new),
    ADAM(Adam::new),
    MINISIM(MiniSimClimber::new),
    INDICATOR(IndicatorClimber::new);

    private final Function<Config, HillClimber> factory;

    private HillClimberType(Function<Config, HillClimber> factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public HillClimber create(Config config) {
        return this.factory.apply(config);
    }
}

