/*
 * Decompiled with CFR 0.152.
 */
package com.github.bingoohuang.patchca.background;

import com.github.bingoohuang.patchca.Patchca1;
import com.github.bingoohuang.patchca.background.BackgroundFactory;
import com.github.bingoohuang.patchca.service.Captcha;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;

public class MyCustomBackgroundFactory
implements BackgroundFactory {
    private Random random = new Random();

    @Override
    public void fillBackground(BufferedImage image) {
        Graphics graphics = image.getGraphics();
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, imgWidth, imgHeight);
        for (int i = 0; i < 100; ++i) {
            int rInt = this.random.nextInt(255);
            int gInt = this.random.nextInt(255);
            int bInt = this.random.nextInt(255);
            graphics.setColor(new Color(rInt, gInt, bInt));
            int xInt = this.random.nextInt(imgWidth - 3);
            int yInt = this.random.nextInt(imgHeight - 2);
            int sAngleInt = this.random.nextInt(360);
            int eAngleInt = this.random.nextInt(360);
            int wInt = this.random.nextInt(6);
            int hInt = this.random.nextInt(6);
            graphics.fillArc(xInt, yInt, wInt, hInt, sAngleInt, eAngleInt);
            if (i % 20 != 0) continue;
            int xInt2 = this.random.nextInt(imgWidth);
            int yInt2 = this.random.nextInt(imgHeight);
            graphics.drawLine(xInt, yInt, xInt2, yInt2);
        }
    }

    public static void main(String[] args) throws IOException {
        Captcha captcha = Patchca1.next();
        String validationCode = captcha.getChallenge();
        System.out.println(validationCode);
        BufferedImage bufferedImage = captcha.getImage();
        ImageIO.write((RenderedImage)bufferedImage, "png", new FileOutputStream(new File("mycustom.png")));
    }
}

