/*
 * Decompiled with CFR 0.152.
 */
package dasniko.testcontainers.keycloak;

import dasniko.testcontainers.keycloak.HttpsClientAuth;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FilenameUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.keycloak.admin.client.Keycloak;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.MountableFile;

public abstract class ExtendableKeycloakContainer<SELF extends ExtendableKeycloakContainer<SELF>>
extends GenericContainer<SELF> {
    public static final String MASTER_REALM = "master";
    public static final String ADMIN_CLI_CLIENT = "admin-cli";
    private static final String KEYCLOAK_IMAGE = "quay.io/keycloak/keycloak";
    private static final String KEYCLOAK_VERSION = "23.0";
    private static final int KEYCLOAK_PORT_HTTP = 8080;
    private static final int KEYCLOAK_PORT_HTTPS = 8443;
    private static final int KEYCLOAK_PORT_DEBUG = 8787;
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(2L);
    private static final String KEYCLOAK_ADMIN_USER = "admin";
    private static final String KEYCLOAK_ADMIN_PASSWORD = "admin";
    private static final String KEYCLOAK_CONTEXT_PATH = "";
    private static final String DEFAULT_KEYCLOAK_PROVIDERS_NAME = "providers.jar";
    private static final String DEFAULT_KEYCLOAK_PROVIDERS_LOCATION = "/opt/keycloak/providers";
    private static final String DEFAULT_REALM_IMPORT_FILES_LOCATION = "/opt/keycloak/data/import/";
    private static final String KEYSTORE_FILE_IN_CONTAINER = "/opt/keycloak/conf/server.keystore";
    private static final String TRUSTSTORE_FILE_IN_CONTAINER = "/opt/keycloak/conf/server.truststore";
    private String adminUsername = "admin";
    private String adminPassword = "admin";
    private String contextPath = "";
    private final Set<String> importFiles;
    private String tlsCertificateFilename;
    private String tlsCertificateKeyFilename;
    private String tlsKeystoreFilename;
    private String tlsKeystorePassword;
    private String tlsTruststoreFilename;
    private String tlsTruststorePassword;
    private boolean useTls = false;
    private boolean disabledCaching = false;
    private boolean metricsEnabled = false;
    private boolean debugEnabled = false;
    private int debugHostPort;
    private boolean debugSuspend = false;
    private HttpsClientAuth httpsClientAuth = HttpsClientAuth.NONE;
    private boolean useVerbose = false;
    private String[] featuresEnabled = null;
    private String[] featuresDisabled = null;
    private Duration startupTimeout = DEFAULT_STARTUP_TIMEOUT;
    private String providerClassLocation;
    private List<File> providerLibsLocations;

    public ExtendableKeycloakContainer() {
        this("quay.io/keycloak/keycloak:23.0");
    }

    public ExtendableKeycloakContainer(String dockerImageName) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{8080, 8443});
        this.importFiles = new HashSet<String>();
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(this.logger()));
    }

    protected void configure() {
        ArrayList<Object> commandParts = new ArrayList<Object>();
        if (this.useVerbose) {
            commandParts.add("--verbose");
        }
        commandParts.add("start-dev");
        if (!this.contextPath.equals(KEYCLOAK_CONTEXT_PATH)) {
            commandParts.add("--http-relative-path=" + this.contextPath);
        }
        if (this.featuresEnabled != null) {
            commandParts.add("--features=" + String.join((CharSequence)",", this.featuresEnabled));
        }
        if (this.featuresDisabled != null) {
            commandParts.add("--features-disabled=" + String.join((CharSequence)",", this.featuresDisabled));
        }
        this.setWaitStrategy(Wait.forHttp((String)this.contextPath).forPort(8080).withStartupTimeout(this.startupTimeout));
        this.withEnv("KEYCLOAK_ADMIN", this.adminUsername);
        this.withEnv("KEYCLOAK_ADMIN_PASSWORD", this.adminPassword);
        if (this.useTls && this.isNotBlank(this.tlsCertificateFilename)) {
            String tlsCertFilePath = "/opt/keycloak/conf/tls.crt";
            String tlsCertKeyFilePath = "/opt/keycloak/conf/tls.key";
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertificateFilename), tlsCertFilePath);
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsCertificateKeyFilename), tlsCertKeyFilePath);
            commandParts.add("--https-certificate-file=" + tlsCertFilePath);
            commandParts.add("--https-certificate-key-file=" + tlsCertKeyFilePath);
        } else if (this.useTls && this.isNotBlank(this.tlsKeystoreFilename)) {
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsKeystoreFilename), KEYSTORE_FILE_IN_CONTAINER);
            commandParts.add("--https-key-store-file=/opt/keycloak/conf/server.keystore");
            commandParts.add("--https-key-store-password=" + this.tlsKeystorePassword);
        }
        if (this.useTls && this.isNotBlank(this.tlsTruststoreFilename)) {
            this.withCopyFileToContainer(MountableFile.forClasspathResource((String)this.tlsTruststoreFilename), TRUSTSTORE_FILE_IN_CONTAINER);
            commandParts.add("--https-trust-store-file=/opt/keycloak/conf/server.truststore");
            commandParts.add("--https-trust-store-password=" + this.tlsTruststorePassword);
            commandParts.add("--https-client-auth=" + this.httpsClientAuth);
        }
        if (this.providerClassLocation != null) {
            this.createKeycloakExtensionProvider(this.providerClassLocation);
        }
        if (this.providerLibsLocations != null) {
            this.providerLibsLocations.forEach(file -> {
                String containerPath = "/opt/keycloak/providers/" + file.getName();
                this.withCopyFileToContainer(MountableFile.forHostPath((String)file.getAbsolutePath()), containerPath);
            });
        }
        if (!this.importFiles.isEmpty()) {
            for (String importFile : this.importFiles) {
                String importFileInContainer = DEFAULT_REALM_IMPORT_FILES_LOCATION + FilenameUtils.getName((String)importFile);
                this.withCopyFileToContainer(MountableFile.forClasspathResource((String)importFile), importFileInContainer);
            }
            commandParts.add("--import-realm");
        }
        if (!this.disabledCaching) {
            this.withEnv("KC_SPI_THEME_CACHE_THEMES", String.valueOf(true));
            this.withEnv("KC_SPI_THEME_CACHE_TEMPLATES", String.valueOf(true));
            this.withEnv("KC_SPI_THEME_STATIC_MAX_AGE", String.valueOf(2592000));
        }
        commandParts.add("--metrics-enabled=" + this.metricsEnabled);
        if (this.debugEnabled) {
            commandParts.add("--debug");
            this.withEnv("DEBUG_PORT", "*:8787");
            if (this.debugHostPort > 0) {
                this.addFixedExposedPort(this.debugHostPort, 8787);
            } else {
                this.addExposedPort(8787);
            }
            if (this.debugSuspend) {
                this.withEnv("DEBUG_SUSPEND", "y");
            }
        }
        this.setCommand(commandParts.toArray(new String[0]));
    }

    public SELF withCommand(String cmd) {
        throw new IllegalStateException("You are trying to set custom container commands, which is currently not supported by this Testcontainer.");
    }

    public SELF withCommand(String ... commandParts) {
        throw new IllegalStateException("You are trying to set custom container commands, which is currently not supported by this Testcontainer.");
    }

    public void createKeycloakExtensionProvider(String extensionClassFolder) {
        this.createKeycloakExtensionDeployment(DEFAULT_KEYCLOAK_PROVIDERS_LOCATION, DEFAULT_KEYCLOAK_PROVIDERS_NAME, extensionClassFolder);
    }

    protected void createKeycloakExtensionDeployment(String deploymentLocation, String extensionName, String extensionClassFolder) {
        Objects.requireNonNull(deploymentLocation, "deploymentLocation must not be null");
        Objects.requireNonNull(extensionName, "extensionName must not be null");
        Objects.requireNonNull(extensionClassFolder, "extensionClassFolder must not be null");
        String classesLocation = this.resolveExtensionClassLocation(extensionClassFolder);
        if (new File(classesLocation).exists()) {
            try {
                File file = Files.createTempFile("keycloak", ".jar", new FileAttribute[0]).toFile();
                file.setReadable(true, false);
                file.deleteOnExit();
                ((ZipExporter)((ExplodedImporter)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)extensionName)).as(ExplodedImporter.class)).importDirectory(classesLocation).as(ZipExporter.class)).exportTo(file, true);
                this.withCopyFileToContainer(MountableFile.forHostPath((String)file.getAbsolutePath()), deploymentLocation + "/" + extensionName);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected String resolveExtensionClassLocation(String extensionClassFolder) {
        return Paths.get(MountableFile.forClasspathResource((String)".").getResolvedPath(), new String[0]).getParent().getParent().resolve(extensionClassFolder).toString();
    }

    public SELF withRealmImportFile(String importFile) {
        this.importFiles.add(importFile);
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withRealmImportFiles(String ... files) {
        Arrays.stream(files).forEach(this::withRealmImportFile);
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withProviderClassesFrom(String classesLocation) {
        this.providerClassLocation = classesLocation;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withProviderLibsFrom(List<File> libs) {
        this.providerLibsLocations = libs;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF useTls() {
        return this.useTlsKeystore("tls.jks", "changeit");
    }

    public SELF useTls(String tlsCertificateFilename, String tlsCertificateKeyFilename) {
        Objects.requireNonNull(tlsCertificateFilename, "tlsCertificateFilename must not be null");
        Objects.requireNonNull(tlsCertificateKeyFilename, "tlsCertificateKeyFilename must not be null");
        this.tlsCertificateFilename = tlsCertificateFilename;
        this.tlsCertificateKeyFilename = tlsCertificateKeyFilename;
        this.useTls = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF useTlsKeystore(String tlsKeystoreFilename, String tlsKeystorePassword) {
        Objects.requireNonNull(tlsKeystoreFilename, "tlsKeystoreFilename must not be null");
        Objects.requireNonNull(tlsKeystorePassword, "tlsKeystorePassword must not be null");
        this.tlsKeystoreFilename = tlsKeystoreFilename;
        this.tlsKeystorePassword = tlsKeystorePassword;
        this.useTls = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF useMutualTls(String tlsTruststoreFilename, String tlsTruststorePassword, HttpsClientAuth httpsClientAuth) {
        Objects.requireNonNull(tlsTruststoreFilename, "tlsTruststoreFilename must not be null");
        Objects.requireNonNull(tlsTruststorePassword, "tlsTruststorePassword must not be null");
        Objects.requireNonNull(httpsClientAuth, "httpsClientAuth must not be null");
        this.tlsTruststoreFilename = tlsTruststoreFilename;
        this.tlsTruststorePassword = tlsTruststorePassword;
        this.httpsClientAuth = httpsClientAuth;
        this.useTls = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withVerboseOutput() {
        this.useVerbose = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withFeaturesEnabled(String ... features) {
        this.featuresEnabled = features;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withFeaturesDisabled(String ... features) {
        this.featuresDisabled = features;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withDisabledCaching() {
        this.disabledCaching = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withEnabledMetrics() {
        this.metricsEnabled = true;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public SELF withDebug() {
        return this.withDebugFixedPort(0, false);
    }

    public SELF withDebugFixedPort(int hostPort, boolean suspend) {
        return this.withDebug(hostPort, suspend);
    }

    private SELF withDebug(int hostPort, boolean suspend) {
        this.debugEnabled = true;
        this.debugHostPort = hostPort;
        this.debugSuspend = suspend;
        return (SELF)((Object)((ExtendableKeycloakContainer)this.self()));
    }

    public Keycloak getKeycloakAdminClient() {
        if (this.useTls) {
            return Keycloak.getInstance((String)this.getAuthServerUrl(), (String)MASTER_REALM, (String)this.getAdminUsername(), (String)this.getAdminPassword(), (String)ADMIN_CLI_CLIENT, (SSLContext)this.buildSslContext());
        }
        return Keycloak.getInstance((String)this.getAuthServerUrl(), (String)MASTER_REALM, (String)this.getAdminUsername(), (String)this.getAdminPassword(), (String)ADMIN_CLI_CLIENT);
    }

    private SSLContext buildSslContext() {
        SSLContext sslContext;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            if (this.tlsKeystoreFilename != null) {
                keyStore.load(this.loadResourceAsStream(this.tlsKeystoreFilename), this.tlsKeystorePassword.toCharArray());
            } else if (this.tlsCertificateFilename != null) {
                keyStore.load(null);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(this.loadResourceAsStream(this.tlsCertificateFilename));
                keyStore.setCertificateEntry(certificate.getSubjectX500Principal().getName(), certificate);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
        }
        catch (IOException | GeneralSecurityException e) {
            sslContext = null;
        }
        return sslContext;
    }

    private InputStream loadResourceAsStream(String filename) {
        return ExtendableKeycloakContainer.class.getClassLoader().getResourceAsStream(filename);
    }

    public String getAuthServerUrl() {
        return String.format("http%s://%s:%s%s", this.useTls ? "s" : KEYCLOAK_CONTEXT_PATH, this.getHost(), this.useTls ? this.getHttpsPort() : this.getHttpPort(), this.getContextPath());
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public int getHttpPort() {
        return this.getMappedPort(8080);
    }

    public int getHttpsPort() {
        return this.getMappedPort(8443);
    }

    public int getDebugPort() {
        return this.debugEnabled ? this.getMappedPort(8787) : -1;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    public String getKeycloakDefaultVersion() {
        return KEYCLOAK_VERSION;
    }

    private boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }
}

