/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.geometry.internal;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import com.github.davidmoten.rtree.geometry.internal.GeometryUtil;
import com.github.davidmoten.rtree.geometry.internal.PointFloat;
import com.github.davidmoten.rtree.geometry.internal.RectangleDouble;
import com.github.davidmoten.rtree.internal.util.ObjectsHelper;

public final class RectangleFloat
implements Rectangle {
    public final float x1;
    public final float y1;
    public final float x2;
    public final float y2;

    private RectangleFloat(float x1, float y1, float x2, float y2) {
        Preconditions.checkArgument((x2 >= x1 ? 1 : 0) != 0);
        Preconditions.checkArgument((y2 >= y1 ? 1 : 0) != 0);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static Rectangle create(float x1, float y1, float x2, float y2) {
        return new RectangleFloat(x1, y1, x2, y2);
    }

    @Override
    public double x1() {
        return this.x1;
    }

    @Override
    public double y1() {
        return this.y1;
    }

    @Override
    public double x2() {
        return this.x2;
    }

    @Override
    public double y2() {
        return this.y2;
    }

    @Override
    public double area() {
        return (this.x2 - this.x1) * (this.y2 - this.y1);
    }

    @Override
    public Rectangle add(Rectangle r) {
        if (r.isDoublePrecision()) {
            return RectangleDouble.create(GeometryUtil.min((double)this.x1, r.x1()), GeometryUtil.min((double)this.y1, r.y1()), GeometryUtil.max((double)this.x2, r.x2()), GeometryUtil.max((double)this.y2, r.y2()));
        }
        if (r instanceof RectangleFloat) {
            RectangleFloat rf = (RectangleFloat)r;
            return RectangleFloat.create(GeometryUtil.min(this.x1, rf.x1), GeometryUtil.min(this.y1, rf.y1), GeometryUtil.max(this.x2, rf.x2), GeometryUtil.max(this.y2, rf.y2));
        }
        PointFloat rf = (PointFloat)r;
        return RectangleFloat.create(GeometryUtil.min(this.x1, rf.xFloat()), GeometryUtil.min(this.y1, rf.yFloat()), GeometryUtil.max(this.x2, rf.xFloat()), GeometryUtil.max(this.y2, rf.yFloat()));
    }

    @Override
    public boolean contains(double x, double y) {
        return x >= (double)this.x1 && x <= (double)this.x2 && y >= (double)this.y1 && y <= (double)this.y2;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return GeometryUtil.intersects(this.x1, this.y1, this.x2, this.y2, r.x1(), r.y1(), r.x2(), r.y2());
    }

    @Override
    public double distance(Rectangle r) {
        return GeometryUtil.distance(this.x1, this.y1, this.x2, this.y2, r.x1(), r.y1(), r.x2(), r.y2());
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Float.valueOf(this.x1), Float.valueOf(this.y1), Float.valueOf(this.x2), Float.valueOf(this.y2)});
    }

    public boolean equals(Object obj) {
        Optional<RectangleFloat> other = ObjectsHelper.asClass(obj, RectangleFloat.class);
        if (other.isPresent()) {
            return Objects.equal((Object)Float.valueOf(this.x1), (Object)Float.valueOf(((RectangleFloat)other.get()).x1)) && Objects.equal((Object)Float.valueOf(this.x2), (Object)Float.valueOf(((RectangleFloat)other.get()).x2)) && Objects.equal((Object)Float.valueOf(this.y1), (Object)Float.valueOf(((RectangleFloat)other.get()).y1)) && Objects.equal((Object)Float.valueOf(this.y2), (Object)Float.valueOf(((RectangleFloat)other.get()).y2));
        }
        return false;
    }

    @Override
    public double intersectionArea(Rectangle r) {
        if (!this.intersects(r)) {
            return 0.0;
        }
        return RectangleDouble.create(GeometryUtil.max((double)this.x1, r.x1()), GeometryUtil.max((double)this.y1, r.y1()), GeometryUtil.min((double)this.x2, r.x2()), GeometryUtil.min((double)this.y2, r.y2())).area();
    }

    @Override
    public double perimeter() {
        return 2.0f * (this.x2 - this.x1) + 2.0f * (this.y2 - this.y1);
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    @Override
    public boolean isDoublePrecision() {
        return false;
    }

    public String toString() {
        return "Rectangle [x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + "]";
    }
}

