/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.command;

import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.internal.io.CRLFTerminatedReader;
import org.subethamail.smtp.internal.server.BaseCommand;
import org.subethamail.smtp.server.Session;

public final class AuthCommand
extends BaseCommand {
    public static final String VERB = "AUTH";
    public static final String AUTH_CANCEL_COMMAND = "*";

    public AuthCommand() {
        super(VERB, "Authentication service", "AUTH <mechanism> [initial-response] \n\t mechanism = a string identifying a SASL authentication mechanism,\n\t an optional base64-encoded response");
    }

    @Override
    public void execute(String commandString, Session sess) throws IOException {
        if (sess.isAuthenticated()) {
            sess.sendResponse("503 Refusing any other AUTH command.");
            return;
        }
        Optional<AuthenticationHandlerFactory> authFactory = sess.getServer().getAuthenticationHandlerFactory();
        if (!authFactory.isPresent()) {
            sess.sendResponse("502 Authentication not supported");
            return;
        }
        AuthenticationHandler authHandler = authFactory.get().create();
        String[] args = AuthCommand.getArgs(commandString);
        if (args.length < 2) {
            sess.sendResponse("501 Syntax: AUTH mechanism [initial-response]");
            return;
        }
        String mechanism = args[1];
        if (!authFactory.get().getAuthenticationMechanisms().contains(mechanism.toUpperCase(Locale.ENGLISH))) {
            sess.sendResponse("504 The requested authentication mechanism is not supported");
            return;
        }
        try {
            CRLFTerminatedReader reader = sess.getReader();
            Optional<String> response = authHandler.auth(commandString, sess);
            if (response.isPresent()) {
                sess.sendResponse(response.get());
            }
            while (response.isPresent()) {
                String clientInput = reader.readLine();
                if (clientInput == null || clientInput.trim().equals(AUTH_CANCEL_COMMAND)) {
                    sess.sendResponse("501 Authentication canceled by client.");
                    return;
                }
                response = authHandler.auth(clientInput, sess);
                if (!response.isPresent()) continue;
                sess.sendResponse(response.get());
            }
            sess.sendResponse("235 Authentication successful.");
            sess.setAuthenticationHandler(authHandler);
        }
        catch (RejectException authFailed) {
            sess.sendResponse(authFailed.getErrorResponse());
        }
    }
}

