/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.server;

import org.subethamail.smtp.internal.command.AuthCommand;
import org.subethamail.smtp.internal.command.BdatCommand;
import org.subethamail.smtp.internal.command.DataCommand;
import org.subethamail.smtp.internal.command.EhloCommand;
import org.subethamail.smtp.internal.command.ExpandCommand;
import org.subethamail.smtp.internal.command.HelloCommand;
import org.subethamail.smtp.internal.command.HelpCommand;
import org.subethamail.smtp.internal.command.MailCommand;
import org.subethamail.smtp.internal.command.NoopCommand;
import org.subethamail.smtp.internal.command.QuitCommand;
import org.subethamail.smtp.internal.command.ReceiptCommand;
import org.subethamail.smtp.internal.command.ResetCommand;
import org.subethamail.smtp.internal.command.StartTLSCommand;
import org.subethamail.smtp.internal.command.VerifyCommand;
import org.subethamail.smtp.internal.server.Command;
import org.subethamail.smtp.internal.server.RequireAuthCommandWrapper;
import org.subethamail.smtp.internal.server.RequireTLSCommandWrapper;

public enum CommandRegistry {
    AUTH(new AuthCommand(), true, false),
    DATA(new DataCommand(), true, true),
    EHLO(new EhloCommand(), false, false),
    HELO(new HelloCommand(), true, false),
    HELP(new HelpCommand(), true, true),
    MAIL(new MailCommand(), true, true),
    NOOP(new NoopCommand(), false, false),
    QUIT(new QuitCommand(), false, false),
    RCPT(new ReceiptCommand(), true, true),
    RSET(new ResetCommand(), true, false),
    STARTTLS(new StartTLSCommand(), false, false),
    VRFY(new VerifyCommand(), true, true),
    EXPN(new ExpandCommand(), true, true),
    BDAT(new BdatCommand(), true, true);

    private final Command command;

    private CommandRegistry(Command cmd, boolean checkForStartedTLSWhenRequired, boolean checkForAuthIfRequired) {
        Command c = checkForStartedTLSWhenRequired ? new RequireTLSCommandWrapper(cmd) : cmd;
        this.command = checkForAuthIfRequired ? new RequireAuthCommandWrapper(c) : c;
    }

    public Command getCommand() {
        return this.command;
    }
}

