/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.text.utils;

import java.util.Arrays;

final class StringBuilder2
implements CharSequence {
    private char[] chars;
    private int length;

    StringBuilder2(String s) {
        this(s.toCharArray(), s.length());
    }

    StringBuilder2() {
        this(new char[16], 0);
    }

    private StringBuilder2(char[] chars, int length) {
        this.chars = chars;
        this.length = length;
    }

    char[] internalArray() {
        return this.chars;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.chars[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        char[] chars2 = new char[end - start];
        System.arraycopy(this.chars, start, chars2, 0, end - start);
        return new StringBuilder2(chars2, chars2.length);
    }

    public void append(StringBuilder2 s) {
        int len = s.length();
        this.checkSize(len);
        System.arraycopy(s.chars, 0, this.chars, this.length, len);
        this.length += len;
    }

    private void checkSize(int len) {
        if (this.length + len > this.chars.length) {
            this.chars = Arrays.copyOf(this.chars, this.newSize(len));
        }
    }

    private int newSize(int len) {
        int newSize = this.chars.length * 2;
        if (newSize < this.length + len) {
            newSize = this.length + len;
        }
        return newSize;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void append(char ch) {
        this.checkSize(1);
        this.chars[this.length] = ch;
        ++this.length;
    }

    public void delete(int start, int end) {
        System.arraycopy(this.chars, end, this.chars, start, this.length - end);
        this.length -= end - start;
    }

    public String substring(int start, int end) {
        return new String(this.chars, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.chars, 0, this.length);
    }

    StringBuilder2 rightTrim() {
        int i;
        for (i = this.length(); i > 0 && Character.isWhitespace(this.charAt(i - 1)); --i) {
        }
        this.length = i;
        return this;
    }
}

