/*
 * Copyright (c) 2009 Rick Mugridge, www.RimuResearch.com
 * Released under the terms of the GNU General Public License version 2 or later.
*/
package fitlibrary.dynamicVariable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import fit.Fixture;

public abstract class DynamicVariablesMap implements DynamicVariables {
	private Map<Object,Object> map = new HashMap<Object,Object>(System.getProperties());

	public DynamicVariablesMap() {
		//
	}
	public DynamicVariablesMap(DynamicVariables dynamicVariables) {
		map = new HashMap<Object,Object>(dynamicVariables.getMap());
	}
	public String resolve(String locator) {
		String result = locator;
		int pos = 0;
		int loops = 0;
		while (true) {
			pos = result.indexOf("@{",pos);
			if (pos < 0)
				break;
			if (loops++ > 10000)
				return "INFINITE SUBSTITUTION!";
			int end = result.indexOf("}",pos);
			if (end >= 0) {
				Object substitute = get(result.substring(pos+2,end));
				if (substitute != null) {
					result = result.substring(0,pos) + Fixture.escape(substitute.toString()) + result.substring(end+1);
					pos = 0;
				}
				else
					pos += 2;
			}
		}
		return result;
	}
	public void put(String key, Object value) {
		map.put(key, value);
	}
	public void putAll(Properties properties) {
		map.putAll(properties);
	}
	public void clearAll() {
		map.clear();
	}
	public Object get(String key) {
		return map.get(key);
	}
	public String getAsString(String key) {
		Object result = get(key);
		if (result == null)
			return null;
		return result.toString();
	}
	public Map<Object,Object> getMap() {
		return new HashMap<Object,Object>(map);
	}
	@Override
	public String toString() {
		StringBuilder s = new StringBuilder();
		ArrayList<Object> keys = new ArrayList<Object>(map.keySet());
		Collections.sort(keys, new Comparator<Object>() {
			public int compare(Object o1, Object o2) {
				return o1.toString().compareTo(o2.toString());
			}
		});
		for (Object key : keys) {
			s.append(key);
			s.append(" = ");
			s.append(map.get(key));
			s.append("<br/>");
		}
		return s.toString();
	}
}
