/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="ga", nsUri="http://schemas.google.com/ga/2009", localName="step")
public class Step
extends ExtensionPoint {
    static final String XML_NAME = "step";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String PATH = "path";
    private String name = null;
    private Integer number = null;
    private String path = null;

    public Step() {
    }

    public Step(String name, Integer number, String path) {
        this.setName(name);
        this.setNumber(number);
        this.setPath(path);
        this.setImmutable(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.throwExceptionIfImmutable();
        this.number = number;
    }

    public boolean hasNumber() {
        return this.getNumber() != null;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.throwExceptionIfImmutable();
        this.path = path;
    }

    public boolean hasPath() {
        return this.getPath() != null;
    }

    protected void validate() {
        if (this.name == null) {
            Step.throwExceptionForMissingAttribute((String)NAME);
        }
        if (this.number == null) {
            Step.throwExceptionForMissingAttribute((String)NUMBER);
        }
        if (this.path == null) {
            Step.throwExceptionForMissingAttribute((String)PATH);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Step.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put((Object)NAME, (Object)this.name);
        generator.put(NUMBER, (Object)this.number);
        generator.put((Object)PATH, (Object)this.path);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.name = helper.consume(NAME, true);
        this.number = helper.consumeInteger(NUMBER, true);
        this.path = helper.consume(PATH, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Step other = (Step)((Object)obj);
        return Step.eq((Object)this.name, (Object)other.name) && Step.eq((Object)this.number, (Object)other.number) && Step.eq((Object)this.path, (Object)other.path);
    }

    public int hashCode() {
        int result = ((Object)((Object)this)).getClass().hashCode();
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        if (this.number != null) {
            result = 37 * result + this.number.hashCode();
        }
        if (this.path != null) {
            result = 37 * result + this.path.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Step name=" + this.name + " number=" + this.number + " path=" + this.path + "}";
    }
}

