/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.codesearch;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.data.codesearch.CodeSearchFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class CodeSearchService
extends GoogleService {
    public static final String CODESEARCH_SERVICE = "codesearch";
    public static final String CODESEARCH_SERVICE_VERSION = "CodeSearch-Java/" + CodeSearchService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(CodeSearchService.class, (Version)Versions.V2);

    public CodeSearchService(String applicationName) {
        super(CODESEARCH_SERVICE, applicationName, "https", "www.google.com");
        this.declareExtensions();
    }

    public CodeSearchService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public CodeSearchService(String applicationName, String protocol, String domainName) {
        super(CODESEARCH_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    public String getServiceVersion() {
        return CODESEARCH_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(CodeSearchService.class);
    }

    private void declareExtensions() {
        new CodeSearchFeed().declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(CodeSearchService.class, "1.0", new Version[]{Service.Versions.V1});
        public static final Version V2 = new Version(CodeSearchService.class, "2.0", new Version[]{Service.Versions.V2});
    }
}

