/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.maps;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.Service;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.acl.AclFeed;
import com.google.gdata.data.batch.BatchUtils;
import com.google.gdata.data.maps.FeatureFeed;
import com.google.gdata.data.maps.MapFeed;
import com.google.gdata.data.maps.VersionFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class MapsService
extends MediaService {
    public static final String MAPS_SERVICE = "local";
    public static final String MAPS_SERVICE_VERSION = "GMaps-Java/" + MapsService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(MapsService.class, (Version)Versions.V2);

    public MapsService(String applicationName) {
        super(MAPS_SERVICE, applicationName);
        this.declareExtensions();
    }

    public MapsService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public MapsService(String applicationName, String protocol, String domainName) {
        super(MAPS_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    public String getServiceVersion() {
        return MAPS_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(MapsService.class);
    }

    private void declareExtensions() {
        new AclFeed().declareExtensions(this.extProfile);
        new FeatureFeed().declareExtensions(this.extProfile);
        new MapFeed().declareExtensions(this.extProfile);
        new VersionFeed().declareExtensions(this.extProfile);
        BatchUtils.declareExtensions((ExtensionProfile)this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(MapsService.class, "1.0", new Version[]{Service.Versions.V1});
        public static final Version V2 = new Version(MapsService.class, "2.0", new Version[]{Service.Versions.V2});
        public static final Version V2_1 = new Version(MapsService.class, "2.1", new Version[]{Service.Versions.V2_1});

        private Versions() {
        }
    }
}

