/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.maps;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Content;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.OtherContent;
import com.google.gdata.data.batch.BatchId;
import com.google.gdata.data.batch.BatchInterrupted;
import com.google.gdata.data.batch.BatchOperation;
import com.google.gdata.data.batch.BatchStatus;
import com.google.gdata.data.extensions.CustomProperty;
import com.google.gdata.data.extensions.Deleted;
import com.google.gdata.data.extensions.PostalAddress;
import com.google.gdata.data.extensions.ResourceId;
import com.google.gdata.data.extensions.StructuredPostalAddress;
import com.google.gdata.data.maps.DataConstants;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.XmlBlob;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://schemas.google.com/maps/2008#feature")
public class FeatureEntry
extends BaseEntry<FeatureEntry> {
    public static final String KIND = "http://schemas.google.com/maps/2008#feature";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/maps/2008#feature");
    private boolean hasView;
    private boolean isKmlDefault = true;
    public static final ContentType KML_CONTENT = new ContentType("application/vnd.google-earth.kml+xml");

    public FeatureEntry() {
        this.getCategories().add(CATEGORY);
    }

    public FeatureEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(FeatureEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(FeatureEntry.class, new ExtensionDescription(BatchId.class, new XmlNamespace("batch", "http://schemas.google.com/gdata/batch"), "id", false, false, false));
        extProfile.declare(FeatureEntry.class, new ExtensionDescription(BatchInterrupted.class, new XmlNamespace("batch", "http://schemas.google.com/gdata/batch"), "interrupted", false, false, false));
        extProfile.declare(FeatureEntry.class, new ExtensionDescription(BatchOperation.class, new XmlNamespace("batch", "http://schemas.google.com/gdata/batch"), "operation", false, false, false));
        extProfile.declare(FeatureEntry.class, new ExtensionDescription(BatchStatus.class, new XmlNamespace("batch", "http://schemas.google.com/gdata/batch"), "status", false, false, false));
        extProfile.declare(FeatureEntry.class, CustomProperty.getDefaultDescription((boolean)false, (boolean)true));
        extProfile.declare(FeatureEntry.class, new ExtensionDescription(Deleted.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "deleted", false, false, false));
        extProfile.declare(FeatureEntry.class, new ExtensionDescription(PostalAddress.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "postalAddress", false, false, false));
        extProfile.declare(FeatureEntry.class, ResourceId.class);
        extProfile.declare(FeatureEntry.class, StructuredPostalAddress.class);
        new StructuredPostalAddress().declareExtensions(extProfile);
    }

    public BatchId getBatchId() {
        return (BatchId)this.getExtension(BatchId.class);
    }

    public void setBatchId(BatchId batchId) {
        if (batchId == null) {
            this.removeExtension(BatchId.class);
        } else {
            this.setExtension((Extension)batchId);
        }
    }

    public boolean hasBatchId() {
        return this.hasExtension(BatchId.class);
    }

    public BatchInterrupted getBatchInterrupted() {
        return (BatchInterrupted)this.getExtension(BatchInterrupted.class);
    }

    public void setBatchInterrupted(BatchInterrupted batchInterrupted) {
        if (batchInterrupted == null) {
            this.removeExtension(BatchInterrupted.class);
        } else {
            this.setExtension((Extension)batchInterrupted);
        }
    }

    public boolean hasBatchInterrupted() {
        return this.hasExtension(BatchInterrupted.class);
    }

    public BatchOperation getBatchOperation() {
        return (BatchOperation)this.getExtension(BatchOperation.class);
    }

    public void setBatchOperation(BatchOperation batchOperation) {
        if (batchOperation == null) {
            this.removeExtension(BatchOperation.class);
        } else {
            this.setExtension((Extension)batchOperation);
        }
    }

    public boolean hasBatchOperation() {
        return this.hasExtension(BatchOperation.class);
    }

    public BatchStatus getBatchStatus() {
        return (BatchStatus)this.getExtension(BatchStatus.class);
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        if (batchStatus == null) {
            this.removeExtension(BatchStatus.class);
        } else {
            this.setExtension((Extension)batchStatus);
        }
    }

    public boolean hasBatchStatus() {
        return this.hasExtension(BatchStatus.class);
    }

    public List<CustomProperty> getCustomProperties() {
        return this.getRepeatingExtension(CustomProperty.class);
    }

    public void addCustomProperty(CustomProperty customProperty) {
        this.getCustomProperties().add(customProperty);
    }

    public boolean hasCustomProperties() {
        return this.hasRepeatingExtension(CustomProperty.class);
    }

    public Deleted getDeleted() {
        return (Deleted)this.getExtension(Deleted.class);
    }

    public void setDeleted(Deleted deleted) {
        if (deleted == null) {
            this.removeExtension(Deleted.class);
        } else {
            this.setExtension((Extension)deleted);
        }
    }

    public boolean hasDeleted() {
        return this.hasExtension(Deleted.class);
    }

    public PostalAddress getPostalAddress() {
        return (PostalAddress)this.getExtension(PostalAddress.class);
    }

    public void setPostalAddress(PostalAddress postalAddress) {
        if (postalAddress == null) {
            this.removeExtension(PostalAddress.class);
        } else {
            this.setExtension((Extension)postalAddress);
        }
    }

    public boolean hasPostalAddress() {
        return this.hasExtension(PostalAddress.class);
    }

    public ResourceId getResourceId() {
        return (ResourceId)this.getExtension(ResourceId.class);
    }

    public void setResourceId(ResourceId resourceId) {
        if (resourceId == null) {
            this.removeExtension(ResourceId.class);
        } else {
            this.setExtension((Extension)resourceId);
        }
    }

    public boolean hasResourceId() {
        return this.hasExtension(ResourceId.class);
    }

    public StructuredPostalAddress getStructuredPostalAddress() {
        return (StructuredPostalAddress)this.getExtension(StructuredPostalAddress.class);
    }

    public void setStructuredPostalAddress(StructuredPostalAddress structuredPostalAddress) {
        if (structuredPostalAddress == null) {
            this.removeExtension(StructuredPostalAddress.class);
        } else {
            this.setExtension((Extension)structuredPostalAddress);
        }
    }

    public boolean hasStructuredPostalAddress() {
        return this.hasExtension(StructuredPostalAddress.class);
    }

    public Link getAtomFeedLink() {
        return this.getLink("http://schemas.google.com/g/2005#feed", ILink.Type.ATOM);
    }

    protected void validate() {
    }

    public String toString() {
        return "{FeatureEntry " + super.toString() + "}";
    }

    public void setKmlDefault(boolean isDefault) {
        this.isKmlDefault = isDefault;
    }

    public boolean hasView() {
        return this.hasView;
    }

    public void setHasView(boolean hasView) {
        this.hasView = hasView;
    }

    public Link getViewLink() {
        return this.getLink("http://schemas.google.com/maps/2008#view", null);
    }

    public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        if (this.isKmlDefault) {
            w.setDefaultNamespace(DataConstants.KML_NAMESPACE);
        }
        super.generateAtom(w, extProfile);
    }

    public XmlBlob getKml() {
        Content content = this.getContent();
        if (null == content || !(content instanceof OtherContent)) {
            return null;
        }
        return ((OtherContent)this.getContent()).getXml();
    }

    public void setKml(XmlBlob kml) {
        OtherContent content = new OtherContent();
        content.setXml(kml);
        content.setMimeType(KML_CONTENT);
        this.setContent((Content)content);
    }
}

