/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="keyword")
public class Keyword
extends AbstractExtension {
    static final String XML_NAME = "keyword";
    private static final String SOURCE = "source";
    private String source = null;
    private String value = null;

    public Keyword() {
    }

    public Keyword(String source, String value) {
        this.setSource(source);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.throwExceptionIfImmutable();
        this.source = source;
    }

    public boolean hasSource() {
        return this.getSource() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.source == null) {
            Keyword.throwExceptionForMissingAttribute((String)SOURCE);
        }
        if (this.value == null) {
            throw new IllegalStateException("Missing text content");
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Keyword.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put((Object)SOURCE, (Object)this.source);
        generator.setContent(this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.source = helper.consume(SOURCE, true);
        this.value = helper.consume(null, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Keyword other = (Keyword)((Object)obj);
        return Keyword.eq((Object)this.source, (Object)other.source) && Keyword.eq((Object)this.value, (Object)other.value);
    }

    public int hashCode() {
        int result = ((Object)((Object)this)).getClass().hashCode();
        if (this.source != null) {
            result = 37 * result + this.source.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Keyword source=" + this.source + " value=" + this.value + "}";
    }

    public static final class Source {
        public static final String EXTERNAL = "external";
        public static final String INTERNAL = "internal";
    }
}

