/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.FeedLinkEntry;
import com.google.gdata.data.youtube.YtPlaylistId;
import com.google.gdata.data.youtube.YtPlaylistTitle;
import com.google.gdata.data.youtube.YtQueryString;
import com.google.gdata.data.youtube.YtUsername;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://gdata.youtube.com/schemas/2007#subscription")
public class SubscriptionEntry
extends FeedLinkEntry<SubscriptionEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/subscriptiontypes.cat"};

    public SubscriptionEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#subscription");
    }

    public SubscriptionEntry(BaseEntry<?> base) {
        super(base);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#subscription");
    }

    public void addSubscriptionType(Type type) {
        this.getCategories().add(new Category("http://gdata.youtube.com/schemas/2007/subscriptiontypes.cat", type.getTerm()));
    }

    public Type getSubscriptionType() {
        for (Category category : this.getCategories()) {
            Type type;
            if (!"http://gdata.youtube.com/schemas/2007/subscriptiontypes.cat".equals(category.getScheme()) || (type = Type.fromTerm(category.getTerm())) == null) continue;
            return type;
        }
        return null;
    }

    public void setSubscriptionType(Type type) {
        this.clearSubscriptionType();
        if (type != null) {
            this.addSubscriptionType(type);
        }
    }

    private void clearSubscriptionType() {
        Iterator categories = this.getCategories().iterator();
        while (categories.hasNext()) {
            Category category = (Category)categories.next();
            if (!"http://gdata.youtube.com/schemas/2007/subscriptiontypes.cat".equals(category.getScheme())) continue;
            categories.remove();
        }
    }

    public void setUsername(String username) {
        if (username != null) {
            this.addExtension((Extension)new YtUsername(username));
        } else {
            this.removeExtension(YtUsername.class);
        }
    }

    public String getUsername() {
        YtUsername username = (YtUsername)this.getExtension(YtUsername.class);
        return username == null ? null : username.getContent();
    }

    public void setQueryString(String query) {
        if (query != null) {
            this.addExtension((Extension)new YtQueryString(query));
        } else {
            this.removeExtension(YtQueryString.class);
        }
    }

    public String getQueryString() {
        YtQueryString query = (YtQueryString)this.getExtension(YtQueryString.class);
        return query == null ? null : query.getContent();
    }

    public void setPlaylistTitle(String playlistTitle) {
        if (playlistTitle != null) {
            this.addExtension((Extension)new YtPlaylistTitle(playlistTitle));
        } else {
            this.removeExtension(YtPlaylistTitle.class);
        }
    }

    public String getPlaylistTitle() {
        YtPlaylistTitle playlistTitle = (YtPlaylistTitle)this.getExtension(YtPlaylistTitle.class);
        return playlistTitle == null ? null : playlistTitle.getContent();
    }

    public void setPlaylistId(String playlistId) {
        if (playlistId != null) {
            this.addExtension((Extension)new YtPlaylistId(playlistId));
        } else {
            this.removeExtension(YtPlaylistId.class);
        }
    }

    public String getPlaylistId() {
        YtPlaylistId playlistId = (YtPlaylistId)this.getExtension(YtPlaylistId.class);
        return playlistId == null ? null : playlistId.getPlaylistId();
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(SubscriptionEntry.class, YtUsername.class);
        extProfile.declare(SubscriptionEntry.class, YtQueryString.class);
        extProfile.declare(SubscriptionEntry.class, YtPlaylistTitle.class);
        extProfile.declare(SubscriptionEntry.class, YtPlaylistId.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CHANNEL,
        FAVORITES,
        QUERY,
        PLAYLIST,
        USER;


        public String getTerm() {
            return this.toString().toLowerCase();
        }

        public static Type fromTerm(String term) {
            try {
                return Type.valueOf(term.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

