/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="recorded")
public class YtRecorded
extends AbstractExtension {
    private DateTime date;

    public YtRecorded() {
    }

    public YtRecorded(DateTime date) {
        this.setDate(date);
    }

    public void setDate(DateTime date) {
        if (date != null && !date.isDateOnly()) {
            throw new IllegalStateException("Object should be only a date, not a date and a time");
        }
        this.date = date;
    }

    public DateTime getDate() {
        return this.date;
    }

    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        if (this.date != null) {
            generator.setContent(this.date.toString());
        }
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        super.consumeAttributes(helper);
        try {
            this.date = DateTime.parseDate((String)helper.consumeContent(true));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid date. Expected format: YYYY-MM-DD");
        }
    }
}

