/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.core.command.AbstrAsyncDockerCmd;
import java.util.Objects;

public class PullImageCmdImpl
extends AbstrAsyncDockerCmd<PullImageCmd, PullResponseItem>
implements PullImageCmd {
    private String repository;
    private String tag;
    private String platform;
    private String registry;
    private AuthConfig authConfig;

    public PullImageCmdImpl(PullImageCmd.Exec exec, AuthConfig authConfig, String repository) {
        super(exec);
        this.withAuthConfig(authConfig);
        this.withRepository(repository);
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public PullImageCmd withAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
        return this;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getRegistry() {
        return this.registry;
    }

    public PullImageCmd withRepository(String repository) {
        this.repository = Objects.requireNonNull(repository, "repository was not specified");
        return this;
    }

    public PullImageCmd withTag(String tag) {
        this.tag = Objects.requireNonNull(tag, "tag was not specified");
        return this;
    }

    public PullImageCmd withPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public PullImageCmd withRegistry(String registry) {
        this.registry = Objects.requireNonNull(registry, "registry was not specified");
        return this;
    }
}

