/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core;

import com.github.dozermapper.core.BeanFactory;
import com.github.dozermapper.core.CustomConverter;
import com.github.dozermapper.core.CustomFieldMapper;
import com.github.dozermapper.core.DozerBeanMapper;
import com.github.dozermapper.core.DozerModule;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.builder.BeanMappingsBuilder;
import com.github.dozermapper.core.builder.DestBeanBuilderCreator;
import com.github.dozermapper.core.builder.xml.BeanMappingXMLBuilder;
import com.github.dozermapper.core.cache.CacheManager;
import com.github.dozermapper.core.cache.DefaultCacheManager;
import com.github.dozermapper.core.cache.DozerCacheType;
import com.github.dozermapper.core.classmap.ClassMapBuilder;
import com.github.dozermapper.core.classmap.ClassMappings;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.MappingFileData;
import com.github.dozermapper.core.classmap.generator.BeanMappingGenerator;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.config.Settings;
import com.github.dozermapper.core.config.processors.DefaultSettingsProcessor;
import com.github.dozermapper.core.config.processors.SettingsProcessor;
import com.github.dozermapper.core.el.DefaultELEngine;
import com.github.dozermapper.core.el.ELEngine;
import com.github.dozermapper.core.el.ELExpressionFactory;
import com.github.dozermapper.core.el.NoopELEngine;
import com.github.dozermapper.core.el.TcclELEngine;
import com.github.dozermapper.core.events.EventListener;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.loader.CustomMappingsLoader;
import com.github.dozermapper.core.loader.LoadMappingsResult;
import com.github.dozermapper.core.loader.MappingsParser;
import com.github.dozermapper.core.loader.api.BeanMappingBuilder;
import com.github.dozermapper.core.loader.xml.ElementReader;
import com.github.dozermapper.core.loader.xml.ExpressionElementReader;
import com.github.dozermapper.core.loader.xml.MappingFileReader;
import com.github.dozermapper.core.loader.xml.MappingStreamReader;
import com.github.dozermapper.core.loader.xml.XMLParser;
import com.github.dozermapper.core.loader.xml.XMLParserFactory;
import com.github.dozermapper.core.osgi.Activator;
import com.github.dozermapper.core.osgi.OSGiClassLoader;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import com.github.dozermapper.core.util.DefaultClassLoader;
import com.github.dozermapper.core.util.DefaultProxyResolver;
import com.github.dozermapper.core.util.DozerClassLoader;
import com.github.dozermapper.core.util.DozerProxyResolver;
import com.github.dozermapper.core.util.MappingUtils;
import com.github.dozermapper.core.util.MappingValidator;
import com.github.dozermapper.core.util.ReflectionUtils;
import com.github.dozermapper.core.util.RuntimeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DozerBeanMapperBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DozerBeanMapperBuilder.class);
    private List<String> mappingFiles = new ArrayList<String>(1);
    private DozerClassLoader fluentDefinedClassLoader;
    private List<CustomConverter> customConverters = new ArrayList<CustomConverter>(0);
    private List<Supplier<InputStream>> xmlMappingSuppliers = new ArrayList<Supplier<InputStream>>(0);
    private List<BeanMappingBuilder> mappingBuilders = new ArrayList<BeanMappingBuilder>(0);
    private List<BeanMappingsBuilder> beanMappingsBuilders = new ArrayList<BeanMappingsBuilder>(0);
    private List<EventListener> eventListeners = new ArrayList<EventListener>(0);
    private CustomFieldMapper customFieldMapper;
    private Map<String, CustomConverter> customConvertersWithId = new HashMap<String, CustomConverter>(0);
    private Map<String, BeanFactory> beanFactories = new HashMap<String, BeanFactory>(0);
    private SettingsProcessor settingsProcessor;
    private ELEngine elEngine;
    private ElementReader elementReader;
    private ClassMappings customMappings;
    private Configuration globalConfiguration;
    private CacheManager cacheManager;

    private DozerBeanMapperBuilder() {
    }

    public static DozerBeanMapperBuilder create() {
        return new DozerBeanMapperBuilder();
    }

    public static Mapper buildDefault() {
        DozerBeanMapperBuilder builder = DozerBeanMapperBuilder.create();
        DozerClassLoader classLoader = builder.getClassLoader();
        URL defaultMappingFile = classLoader.loadResource("dozerBeanMapping.xml");
        if (defaultMappingFile != null) {
            builder.withMappingFiles("dozerBeanMapping.xml");
        }
        return builder.withClassLoader(classLoader).build();
    }

    public DozerBeanMapperBuilder withMappingFiles(String ... mappingFiles) {
        return this.withMappingFiles(Arrays.asList(mappingFiles));
    }

    public DozerBeanMapperBuilder withMappingFiles(List<String> mappingFiles) {
        if (mappingFiles != null) {
            this.mappingFiles.addAll(mappingFiles);
        }
        return this;
    }

    public DozerBeanMapperBuilder withClassLoader(DozerClassLoader classLoader) {
        this.fluentDefinedClassLoader = classLoader;
        return this;
    }

    public DozerBeanMapperBuilder withClassLoader(ClassLoader classLoader) {
        this.fluentDefinedClassLoader = new DefaultClassLoader(classLoader);
        return this;
    }

    public DozerBeanMapperBuilder withCustomConverter(CustomConverter customConverter) {
        return this.withCustomConverters(customConverter);
    }

    public DozerBeanMapperBuilder withCustomConverters(CustomConverter ... customConverters) {
        return this.withCustomConverters(Arrays.asList(customConverters));
    }

    public DozerBeanMapperBuilder withCustomConverters(List<CustomConverter> customConverters) {
        if (customConverters != null) {
            this.customConverters.addAll(customConverters);
        }
        return this;
    }

    public DozerBeanMapperBuilder withXmlMapping(Supplier<InputStream> xmlMappingSupplier) {
        this.xmlMappingSuppliers.add(xmlMappingSupplier);
        return this;
    }

    public DozerBeanMapperBuilder withMappingBuilder(BeanMappingBuilder mappingBuilder) {
        return this.withMappingBuilders(mappingBuilder);
    }

    public DozerBeanMapperBuilder withMappingBuilders(BeanMappingBuilder ... mappingBuilders) {
        return this.withMappingBuilders(Arrays.asList(mappingBuilders));
    }

    public DozerBeanMapperBuilder withMappingBuilders(List<BeanMappingBuilder> mappingBuilders) {
        if (mappingBuilders != null) {
            this.mappingBuilders.addAll(mappingBuilders);
        }
        return this;
    }

    public DozerBeanMapperBuilder withBeanMappingsBuilders(BeanMappingsBuilder beanMappingsBuilder) {
        return this.withBeanMappingsBuilders(Arrays.asList(beanMappingsBuilder));
    }

    public DozerBeanMapperBuilder withBeanMappingsBuilders(BeanMappingsBuilder ... beanMappingsBuilder) {
        return this.withBeanMappingsBuilders(Arrays.asList(beanMappingsBuilder));
    }

    public DozerBeanMapperBuilder withBeanMappingsBuilders(List<BeanMappingsBuilder> beanMappingsBuilder) {
        if (beanMappingsBuilder != null) {
            this.beanMappingsBuilders.addAll(beanMappingsBuilder);
        }
        return this;
    }

    public DozerBeanMapperBuilder withEventListener(EventListener eventListener) {
        return this.withEventListeners(eventListener);
    }

    public DozerBeanMapperBuilder withEventListeners(EventListener ... eventListeners) {
        return this.withEventListeners(Arrays.asList(eventListeners));
    }

    public DozerBeanMapperBuilder withEventListeners(List<EventListener> eventListeners) {
        if (eventListeners != null) {
            this.eventListeners.addAll(eventListeners);
        }
        return this;
    }

    public DozerBeanMapperBuilder withCustomFieldMapper(CustomFieldMapper customFieldMapper) {
        this.customFieldMapper = customFieldMapper;
        return this;
    }

    public DozerBeanMapperBuilder withCustomConverterWithId(String converterId, CustomConverter converter) {
        this.customConvertersWithId.put(converterId, converter);
        return this;
    }

    public DozerBeanMapperBuilder withCustomConvertersWithIds(Map<String, CustomConverter> customConvertersWithId) {
        if (customConvertersWithId != null) {
            this.customConvertersWithId.putAll(customConvertersWithId);
        }
        return this;
    }

    public DozerBeanMapperBuilder withBeanFactory(String factoryName, BeanFactory beanFactory) {
        this.beanFactories.put(factoryName, beanFactory);
        return this;
    }

    public DozerBeanMapperBuilder withBeanFactorys(Map<String, BeanFactory> beanFactories) {
        if (beanFactories != null) {
            this.beanFactories.putAll(beanFactories);
        }
        return this;
    }

    public DozerBeanMapperBuilder withSettingsProcessor(SettingsProcessor processor) {
        this.settingsProcessor = processor;
        return this;
    }

    public DozerBeanMapperBuilder withELEngine(ELEngine elEngine) {
        this.elEngine = elEngine;
        return this;
    }

    public DozerBeanMapperBuilder withElementReader(ElementReader elementReader) {
        this.elementReader = elementReader;
        return this;
    }

    public DozerBeanMapperBuilder withCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    public Mapper build() {
        LOG.info("Initializing Dozer. Version: {}, Thread Name: {}", (Object)"7.0.0", (Object)Thread.currentThread().getName());
        DozerClassLoader defaultClassLoader = this.getClassLoader();
        Settings settings = this.getSettings(defaultClassLoader);
        DozerClassLoader settingsClassLoader = this.getClassLoaderFromSettings(settings, defaultClassLoader);
        DozerClassLoader classLoader = settingsClassLoader == null ? defaultClassLoader : settingsClassLoader;
        DozerProxyResolver proxyResolver = this.getProxyResolver(settings, classLoader);
        CacheManager cacheManager = this.getCacheManager(settings);
        ELEngine elEngine = this.getELEngine();
        ElementReader elementReader = this.getElementReader(elEngine);
        BeanContainer beanContainer = new BeanContainer();
        beanContainer.setElEngine(elEngine);
        beanContainer.setElementReader(elementReader);
        beanContainer.setClassLoader(classLoader);
        beanContainer.setProxyResolver(proxyResolver);
        DestBeanCreator destBeanCreator = new DestBeanCreator(beanContainer);
        destBeanCreator.setStoredFactories(this.beanFactories);
        PropertyDescriptorFactory propertyDescriptorFactory = new PropertyDescriptorFactory();
        BeanMappingGenerator beanMappingGenerator = new BeanMappingGenerator(beanContainer, destBeanCreator, propertyDescriptorFactory);
        DestBeanBuilderCreator destBeanBuilderCreator = new DestBeanBuilderCreator();
        this.loadDozerModules(beanContainer, destBeanBuilderCreator, beanMappingGenerator, propertyDescriptorFactory, destBeanCreator);
        ArrayList<MappingFileData> mappingsFileData = new ArrayList<MappingFileData>();
        if (settings.getUseJaxbMappingEngine().booleanValue()) {
            mappingsFileData.addAll(this.buildXmlMappings(beanContainer, destBeanCreator, propertyDescriptorFactory, elEngine));
        } else {
            XMLParser xmlParser = new XMLParser(beanContainer, destBeanCreator, propertyDescriptorFactory);
            XMLParserFactory xmlParserFactory = new XMLParserFactory(beanContainer);
            mappingsFileData.addAll(this.readXmlMappings(xmlParserFactory, xmlParser));
            mappingsFileData.addAll(this.loadFromFiles(this.mappingFiles, xmlParserFactory, xmlParser, beanContainer));
        }
        mappingsFileData.addAll(this.buildGenericMappings(beanContainer, destBeanCreator, propertyDescriptorFactory));
        mappingsFileData.addAll(this.createMappingsWithBuilders(beanContainer, destBeanCreator, propertyDescriptorFactory));
        this.loadCustomMappings(mappingsFileData, beanContainer, propertyDescriptorFactory, beanMappingGenerator, destBeanCreator);
        return new DozerBeanMapper(this.mappingFiles, beanContainer, destBeanCreator, destBeanBuilderCreator, beanMappingGenerator, propertyDescriptorFactory, this.customConverters, mappingsFileData, this.eventListeners, this.customFieldMapper, this.customConvertersWithId, this.customMappings, this.globalConfiguration, cacheManager);
    }

    private List<MappingFileData> createMappingsWithBuilders(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        return this.mappingBuilders.stream().map(fluentBuilder -> fluentBuilder.build(beanContainer, destBeanCreator, propertyDescriptorFactory)).collect(Collectors.toList());
    }

    private List<MappingFileData> readXmlMappings(XMLParserFactory xmlParserFactory, XMLParser xmlParser) {
        return this.xmlMappingSuppliers.stream().map(xmlMappingSupplier -> {
            MappingFileData mappingFileData;
            block8: {
                InputStream xmlMappingStream = (InputStream)xmlMappingSupplier.get();
                try {
                    MappingStreamReader fileReader = new MappingStreamReader(xmlParserFactory, xmlParser);
                    mappingFileData = fileReader.read(xmlMappingStream);
                    if (xmlMappingStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (xmlMappingStream != null) {
                            try {
                                xmlMappingStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MappingException(e);
                    }
                }
                xmlMappingStream.close();
            }
            return mappingFileData;
        }).collect(Collectors.toList());
    }

    private List<MappingFileData> buildXmlMappings(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory, ELEngine elEngine) {
        BeanMappingXMLBuilder builder = new BeanMappingXMLBuilder(beanContainer, elEngine);
        builder.loadFiles(this.mappingFiles);
        builder.loadInputStreams(this.xmlMappingSuppliers);
        return builder.build(beanContainer, destBeanCreator, propertyDescriptorFactory);
    }

    private List<MappingFileData> buildGenericMappings(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        return this.beanMappingsBuilders.stream().map(m -> m.build(beanContainer, destBeanCreator, propertyDescriptorFactory)).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
    }

    private DozerClassLoader getClassLoader() {
        if (this.fluentDefinedClassLoader == null) {
            if (RuntimeUtils.isOSGi()) {
                return new OSGiClassLoader(Activator.getBundle().getBundleContext());
            }
            return new DefaultClassLoader(DozerBeanMapperBuilder.class.getClassLoader());
        }
        return this.fluentDefinedClassLoader;
    }

    private DozerClassLoader getClassLoaderFromSettings(Settings settings, DozerClassLoader defaultClassLoader) {
        DozerClassLoader answer = null;
        String classLoaderName = settings.getClassLoaderBeanName();
        if (!"com.github.dozermapper.core.util.DefaultClassLoader".equalsIgnoreCase(classLoaderName)) {
            answer = ReflectionUtils.newInstance(this.loadBeanType(classLoaderName, defaultClassLoader, DozerClassLoader.class));
        }
        return answer;
    }

    private Settings getSettings(DozerClassLoader classLoader) {
        if (this.settingsProcessor == null) {
            this.settingsProcessor = new DefaultSettingsProcessor(classLoader);
            return this.settingsProcessor.process();
        }
        return this.settingsProcessor.process();
    }

    private DozerProxyResolver getProxyResolver(Settings settings, DozerClassLoader dozerClassLoader) {
        String proxyResolverName = settings.getProxyResolverBeanName();
        DozerProxyResolver answer = "com.github.dozermapper.core.util.DefaultProxyResolver".equalsIgnoreCase(proxyResolverName) ? new DefaultProxyResolver() : ReflectionUtils.newInstance(this.loadBeanType(proxyResolverName, dozerClassLoader, DozerProxyResolver.class));
        return answer;
    }

    private <T> Class<? extends T> loadBeanType(String classLoaderName, DozerClassLoader classLoader, Class<T> iface) {
        Class<?> beanType = classLoader.loadClass(classLoaderName);
        if (beanType != null && !iface.isAssignableFrom(beanType)) {
            MappingUtils.throwMappingException("Incompatible types: " + iface.getName() + " and " + classLoaderName);
        }
        return beanType;
    }

    private CacheManager getCacheManager(Settings settings) {
        if (this.cacheManager == null) {
            DefaultCacheManager cacheManager = new DefaultCacheManager();
            cacheManager.putCache(DozerCacheType.CONVERTER_BY_DEST_TYPE.name(), settings.getConverterByDestTypeCacheMaxSize());
            cacheManager.putCache(DozerCacheType.SUPER_TYPE_CHECK.name(), settings.getSuperTypesCacheMaxSize());
            return cacheManager;
        }
        return this.cacheManager;
    }

    private ELEngine getELEngine() {
        if (this.elEngine == null) {
            if (ELExpressionFactory.isSupported().booleanValue()) {
                if (RuntimeUtils.isOSGi()) {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    return new TcclELEngine(ELExpressionFactory.newInstance(classLoader), classLoader);
                }
                return new DefaultELEngine(ELExpressionFactory.newInstance());
            }
            return new NoopELEngine();
        }
        return this.elEngine;
    }

    private ElementReader getElementReader(ELEngine elEngine) {
        if (this.elementReader == null) {
            return new ExpressionElementReader(elEngine);
        }
        return this.elementReader;
    }

    private void loadCustomMappings(List<MappingFileData> allMappings, BeanContainer beanContainer, PropertyDescriptorFactory propertyDescriptorFactory, BeanMappingGenerator beanMappingGenerator, DestBeanCreator destBeanCreator) {
        MappingsParser mappingsParser = new MappingsParser(beanContainer, destBeanCreator, propertyDescriptorFactory);
        ClassMapBuilder classMapBuilder = new ClassMapBuilder(beanContainer, destBeanCreator, beanMappingGenerator, propertyDescriptorFactory);
        CustomMappingsLoader customMappingsLoader = new CustomMappingsLoader(mappingsParser, classMapBuilder, beanContainer);
        LoadMappingsResult loadMappingsResult = customMappingsLoader.load(allMappings);
        this.customMappings = loadMappingsResult.getCustomMappings();
        this.globalConfiguration = loadMappingsResult.getGlobalConfiguration();
    }

    private List<MappingFileData> loadFromFiles(List<String> mappingFiles, XMLParserFactory xmlParserFactory, XMLParser xmlParser, BeanContainer beanContainer) {
        MappingFileReader mappingFileReader = new MappingFileReader(xmlParserFactory, xmlParser, beanContainer);
        ArrayList<MappingFileData> mappingFileDataList = new ArrayList<MappingFileData>();
        if (mappingFiles != null && mappingFiles.size() > 0) {
            LOG.info("Using the following xml files to load custom mappings for the bean mapper instance: {}", mappingFiles);
            for (String mappingFileName : mappingFiles) {
                LOG.info("Trying to find xml mapping file: {}", (Object)mappingFileName);
                URL url = MappingValidator.validateURL(mappingFileName, beanContainer);
                LOG.info("Using URL [" + url + "] to load custom xml mappings");
                MappingFileData mappingFileData = mappingFileReader.read(url);
                LOG.info("Successfully loaded custom xml mappings from URL: [{}]", (Object)url);
                mappingFileDataList.add(mappingFileData);
            }
        }
        return mappingFileDataList;
    }

    private void loadDozerModules(BeanContainer beanContainer, DestBeanBuilderCreator destBeanBuilderCreator, BeanMappingGenerator beanMappingGenerator, PropertyDescriptorFactory propertyDescriptorFactory, DestBeanCreator destBeanCreator) {
        try {
            ServiceLoader<DozerModule> services = ServiceLoader.load(DozerModule.class);
            for (DozerModule module : services) {
                module.init();
                module.init(beanContainer, destBeanCreator, propertyDescriptorFactory);
                destBeanBuilderCreator.addPluggedStrategies(module.getBeanBuilderCreationStrategies());
                beanMappingGenerator.addPluggedFieldDetectors(module.getBeanFieldsDetectors());
                propertyDescriptorFactory.addPluggedPropertyDescriptorCreationStrategies(module.getPropertyDescriptorCreationStrategies());
            }
        }
        catch (ServiceConfigurationError ex) {
            LOG.error("{}", (Object)ex.getMessage());
        }
    }
}

