/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.builder.model.jaxb;

import com.github.dozermapper.core.builder.model.jaxb.ConfigurationDefinition;
import com.github.dozermapper.core.builder.model.jaxb.MappingDefinition;
import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="mappings")
public class MappingsDefinition {
    @XmlTransient
    private String schemaLocation;
    @XmlElement(name="configuration")
    protected ConfigurationDefinition configuration;
    @XmlElement(name="mapping")
    protected List<MappingDefinition> mapping;

    public ConfigurationDefinition withConfiguration() {
        if (this.configuration == null) {
            this.setConfiguration(new ConfigurationDefinition(this));
        }
        return this.configuration;
    }

    public MappingDefinition addMapping() {
        if (this.mapping == null) {
            this.setMapping(new ArrayList<MappingDefinition>());
        }
        MappingDefinition mapping = new MappingDefinition(this);
        this.getMapping().add(mapping);
        return mapping;
    }

    public List<ClassMap> build(Configuration configuration, BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        ArrayList<ClassMap> answer = new ArrayList<ClassMap>();
        if (this.mapping != null) {
            for (MappingDefinition current : this.mapping) {
                answer.add(current.build(configuration, beanContainer, destBeanCreator, propertyDescriptorFactory));
            }
        }
        return answer;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    protected void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public ConfigurationDefinition getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(ConfigurationDefinition configuration) {
        this.configuration = configuration;
    }

    public List<MappingDefinition> getMapping() {
        return this.mapping;
    }

    protected void setMapping(List<MappingDefinition> mapping) {
        this.mapping = mapping;
    }

    public String toString() {
        return "MappingsDefinition(schemaLocation=" + this.getSchemaLocation() + ", configuration=" + this.getConfiguration() + ", mapping=" + this.getMapping() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappingsDefinition)) {
            return false;
        }
        MappingsDefinition other = (MappingsDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schemaLocation = this.getSchemaLocation();
        String other$schemaLocation = other.getSchemaLocation();
        if (this$schemaLocation == null ? other$schemaLocation != null : !this$schemaLocation.equals(other$schemaLocation)) {
            return false;
        }
        ConfigurationDefinition this$configuration = this.getConfiguration();
        ConfigurationDefinition other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<MappingDefinition> this$mapping = this.getMapping();
        List<MappingDefinition> other$mapping = other.getMapping();
        return !(this$mapping == null ? other$mapping != null : !((Object)this$mapping).equals(other$mapping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MappingsDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schemaLocation = this.getSchemaLocation();
        result = result * 59 + ($schemaLocation == null ? 43 : $schemaLocation.hashCode());
        ConfigurationDefinition $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<MappingDefinition> $mapping = this.getMapping();
        result = result * 59 + ($mapping == null ? 43 : ((Object)$mapping).hashCode());
        return result;
    }
}

