/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.builder.model.jaxb;

import com.github.dozermapper.core.builder.model.jaxb.ConfigurationDefinition;
import com.github.dozermapper.core.builder.model.jaxb.VariableDefinition;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="variables")
public class VariablesDefinition {
    @XmlTransient
    private final ConfigurationDefinition parent;
    @XmlElement(name="variable", required=true)
    protected List<VariableDefinition> variables;

    public VariablesDefinition() {
        this(null);
    }

    public VariablesDefinition(ConfigurationDefinition parent) {
        this.parent = parent;
    }

    public VariableDefinition withVariable() {
        if (this.getVariables() == null) {
            this.setVariables(new ArrayList<VariableDefinition>());
        }
        VariableDefinition variable = new VariableDefinition(this);
        this.getVariables().add(variable);
        return variable;
    }

    public ConfigurationDefinition end() {
        return this.parent;
    }

    public void build() {
        if (this.variables != null && this.variables.size() > 0) {
            for (VariableDefinition current : this.variables) {
                current.build();
            }
        }
    }

    public ConfigurationDefinition getParent() {
        return this.parent;
    }

    public List<VariableDefinition> getVariables() {
        return this.variables;
    }

    protected void setVariables(List<VariableDefinition> variables) {
        this.variables = variables;
    }

    public String toString() {
        return "VariablesDefinition(parent=" + this.getParent() + ", variables=" + this.getVariables() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariablesDefinition)) {
            return false;
        }
        VariablesDefinition other = (VariablesDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfigurationDefinition this$parent = this.getParent();
        ConfigurationDefinition other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        List<VariableDefinition> this$variables = this.getVariables();
        List<VariableDefinition> other$variables = other.getVariables();
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VariablesDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfigurationDefinition $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        List<VariableDefinition> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }
}

