/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.classmap.generator;

import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.classmap.ClassMapBuilder;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.generator.BeanFieldsDetector;
import com.github.dozermapper.core.classmap.generator.GeneratorUtils;
import com.github.dozermapper.core.classmap.generator.JavaBeanFieldsDetector;
import com.github.dozermapper.core.classmap.generator.MappingType;
import com.github.dozermapper.core.classmap.generator.WildcardFieldMapping;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import com.github.dozermapper.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class BeanMappingGenerator
implements ClassMapBuilder.ClassMappingGenerator {
    final List<BeanFieldsDetector> pluggedFieldDetectors = new ArrayList<BeanFieldsDetector>();
    final List<BeanFieldsDetector> availableFieldDetectors = new ArrayList<BeanFieldsDetector>(){
        {
            this.add(new JavaBeanFieldsDetector());
        }
    };
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;

    public BeanMappingGenerator(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    @Override
    public boolean accepts(ClassMap classMap) {
        return true;
    }

    @Override
    public boolean apply(ClassMap classMap, Configuration configuration) {
        Class<?> srcClass = classMap.getSrcClassToMap();
        Class<?> destClass = classMap.getDestClassToMap();
        Set<String> destFieldNames = this.getAcceptsFieldsDetector(destClass).getWritableFieldNames(destClass);
        Set<String> srcFieldNames = this.getAcceptsFieldsDetector(srcClass).getReadableFieldNames(srcClass);
        Set<WildcardFieldMapping> wildcardFieldMappings = classMap.isWildcardCaseInsensitive() ? this.getMatchingFieldsCaseInsensitive(srcFieldNames, destFieldNames) : this.getMatchingFields(srcFieldNames, destFieldNames);
        for (WildcardFieldMapping wildcardFieldMapping : wildcardFieldMappings) {
            if (GeneratorUtils.shouldIgnoreField(wildcardFieldMapping.getSrcFieldName(), srcClass, destClass, this.beanContainer) || GeneratorUtils.shouldIgnoreField(wildcardFieldMapping.getDestFieldName(), srcClass, destClass, this.beanContainer) || classMap.getFieldMapUsingDest(wildcardFieldMapping.getDestFieldName()) != null || classMap.getFieldMapUsingSrc(wildcardFieldMapping.getSrcFieldName()) != null) continue;
            GeneratorUtils.addGenericMapping(MappingType.GETTER_TO_SETTER, classMap, configuration, wildcardFieldMapping.getSrcFieldName(), wildcardFieldMapping.getDestFieldName(), this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
        }
        return false;
    }

    private Set<WildcardFieldMapping> getMatchingFields(Set<String> srcFieldNames, Set<String> destFieldNames) {
        return CollectionUtils.intersection(srcFieldNames, destFieldNames).stream().map(matchingFieldName -> new WildcardFieldMapping((String)matchingFieldName, (String)matchingFieldName)).collect(Collectors.toSet());
    }

    private Set<WildcardFieldMapping> getMatchingFieldsCaseInsensitive(Set<String> srcFieldNames, Set<String> destFieldNames) {
        HashMap<String, String> srcFieldNamesLookup = new HashMap<String, String>(srcFieldNames.size(), 1.0f);
        HashMap<String, String> destFieldNamesLookup = new HashMap<String, String>(destFieldNames.size(), 1.0f);
        for (String srcFieldName : srcFieldNames) {
            srcFieldNamesLookup.put(srcFieldName.toLowerCase(), srcFieldName);
        }
        for (String destFieldName : destFieldNames) {
            destFieldNamesLookup.put(destFieldName.toLowerCase(), destFieldName);
        }
        HashSet<WildcardFieldMapping> wildcardFields = new HashSet<WildcardFieldMapping>();
        for (Map.Entry lowercaseToActualFieldName : srcFieldNamesLookup.entrySet()) {
            if (!destFieldNamesLookup.containsKey(lowercaseToActualFieldName.getKey())) continue;
            wildcardFields.add(new WildcardFieldMapping((String)lowercaseToActualFieldName.getValue(), (String)destFieldNamesLookup.get(lowercaseToActualFieldName.getKey())));
        }
        return wildcardFields;
    }

    private BeanFieldsDetector getAcceptsFieldsDetector(Class<?> clazz) {
        BeanFieldsDetector detector = this.getAcceptsFieldDetector(clazz, this.pluggedFieldDetectors);
        if (detector == null) {
            detector = this.getAcceptsFieldDetector(clazz, this.availableFieldDetectors);
        }
        return detector;
    }

    private BeanFieldsDetector getAcceptsFieldDetector(Class<?> clazz, List<BeanFieldsDetector> detectors) {
        for (BeanFieldsDetector detector : new CopyOnWriteArrayList<BeanFieldsDetector>(detectors)) {
            if (!detector.accepts(clazz)) continue;
            return detector;
        }
        return null;
    }

    public void addPluggedFieldDetectors(Collection<BeanFieldsDetector> beanFieldsDetectors) {
        this.pluggedFieldDetectors.addAll(beanFieldsDetectors);
    }
}

