/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.ReferenceSchema;
import com.github.erosb.jsonsKema.SchemaLoadingException;
import com.github.erosb.jsonsKema.SourceLocation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/github/erosb/jsonsKema/RefResolutionException;", "Lcom/github/erosb/jsonsKema/SchemaLoadingException;", "ref", "Lcom/github/erosb/jsonsKema/ReferenceSchema;", "missingProperty", "", "resolutionFailureLocation", "Lcom/github/erosb/jsonsKema/SourceLocation;", "(Lcom/github/erosb/jsonsKema/ReferenceSchema;Ljava/lang/String;Lcom/github/erosb/jsonsKema/SourceLocation;)V", "getMissingProperty", "()Ljava/lang/String;", "getRef", "()Lcom/github/erosb/jsonsKema/ReferenceSchema;", "getResolutionFailureLocation", "()Lcom/github/erosb/jsonsKema/SourceLocation;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "json-sKema"})
public final class RefResolutionException
extends SchemaLoadingException {
    @NotNull
    private final ReferenceSchema ref;
    @NotNull
    private final String missingProperty;
    @NotNull
    private final SourceLocation resolutionFailureLocation;

    public RefResolutionException(@NotNull ReferenceSchema ref, @NotNull String missingProperty, @NotNull SourceLocation resolutionFailureLocation) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)missingProperty, (String)"missingProperty");
        Intrinsics.checkNotNullParameter((Object)resolutionFailureLocation, (String)"resolutionFailureLocation");
        super("$ref resolution failure: could not evaluate pointer \"" + ref.getRef() + "\", property \"" + missingProperty + "\" not found at " + resolutionFailureLocation.getLocation(), null, 2, null);
        this.ref = ref;
        this.missingProperty = missingProperty;
        this.resolutionFailureLocation = resolutionFailureLocation;
    }

    @NotNull
    public final ReferenceSchema getRef() {
        return this.ref;
    }

    @NotNull
    public final String getMissingProperty() {
        return this.missingProperty;
    }

    @NotNull
    public final SourceLocation getResolutionFailureLocation() {
        return this.resolutionFailureLocation;
    }

    @NotNull
    public final ReferenceSchema component1() {
        return this.ref;
    }

    @NotNull
    public final String component2() {
        return this.missingProperty;
    }

    @NotNull
    public final SourceLocation component3() {
        return this.resolutionFailureLocation;
    }

    @NotNull
    public final RefResolutionException copy(@NotNull ReferenceSchema ref, @NotNull String missingProperty, @NotNull SourceLocation resolutionFailureLocation) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)missingProperty, (String)"missingProperty");
        Intrinsics.checkNotNullParameter((Object)resolutionFailureLocation, (String)"resolutionFailureLocation");
        return new RefResolutionException(ref, missingProperty, resolutionFailureLocation);
    }

    public static /* synthetic */ RefResolutionException copy$default(RefResolutionException refResolutionException, ReferenceSchema referenceSchema, String string, SourceLocation sourceLocation, int n, Object object) {
        if ((n & 1) != 0) {
            referenceSchema = refResolutionException.ref;
        }
        if ((n & 2) != 0) {
            string = refResolutionException.missingProperty;
        }
        if ((n & 4) != 0) {
            sourceLocation = refResolutionException.resolutionFailureLocation;
        }
        return refResolutionException.copy(referenceSchema, string, sourceLocation);
    }

    @Override
    @NotNull
    public String toString() {
        return "RefResolutionException(ref=" + this.ref + ", missingProperty=" + this.missingProperty + ", resolutionFailureLocation=" + this.resolutionFailureLocation + ')';
    }

    public int hashCode() {
        int result = this.ref.hashCode();
        result = result * 31 + this.missingProperty.hashCode();
        result = result * 31 + this.resolutionFailureLocation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RefResolutionException)) {
            return false;
        }
        RefResolutionException refResolutionException = (RefResolutionException)other;
        if (!Intrinsics.areEqual((Object)this.ref, (Object)refResolutionException.ref)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.missingProperty, (Object)refResolutionException.missingProperty)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.resolutionFailureLocation, (Object)refResolutionException.resolutionFailureLocation);
    }
}

