/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.Fongo;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import java.util.List;
import java.util.UUID;

public abstract class PipelineKeyword {
    protected static final FongoDB fongo = new Fongo("aggregation_pipeline").getDB("pipeline");

    public abstract DBCollection apply(DB var1, DBCollection var2, DBObject var3);

    public abstract String getKeyword();

    protected DBCollection dropAndInsert(DBCollection coll, List<DBObject> objects) {
        coll.drop();
        return this.createAndInsert(objects);
    }

    static void errorResult(DBCollection coll, int code, String err) {
        ((FongoDB)coll.getDB()).notOkErrorResult(code, err).throwOnError();
    }

    protected DBCollection createAndInsert(List<DBObject> objects) {
        FongoDBCollection coll = fongo.doGetCollection(UUID.randomUUID().toString(), true, false);
        coll.insert(objects);
        return coll;
    }

    public boolean canApply(DBObject object) {
        return object.containsField(this.getKeyword());
    }

    static <T> void validateNull(T param, String msg) {
        if (param == null) {
            fongo.errorResult(15955, msg).throwOnError();
        }
    }

    static void validateTrue(boolean expr, String msg) {
        if (!expr) {
            fongo.errorResult(15955, msg).throwOnError();
        }
    }
}

