/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.junit;

import com.github.fakemongo.Fongo;
import com.github.fakemongo.async.FongoAsync;
import com.github.fakemongo.junit.FongoRule;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.connection.ServerVersion;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.junit.rules.ExternalResource;

public class FongoAsyncRule
extends ExternalResource {
    private final boolean realMongo;
    private final String dbName;
    private final FongoAsync fongo;
    private MongoClient mongo;
    private MongoDatabase mongoDatabase;

    public FongoAsyncRule(String dbName, ServerVersion serverVersion, boolean realMongo, MongoClient mongoClientIfReal) {
        this.dbName = dbName;
        this.realMongo = realMongo || "true".equals(System.getProperty("fongo.force.realMongo"));
        this.fongo = realMongo ? null : this.newFongo(serverVersion);
        this.mongo = mongoClientIfReal;
    }

    public FongoAsyncRule() {
        this(Fongo.DEFAULT_SERVER_VERSION);
    }

    public FongoAsyncRule(ServerVersion serverVersion) {
        this(FongoRule.randomName(), serverVersion, false, null);
    }

    public FongoAsyncRule(boolean realMongo) {
        this(realMongo, Fongo.DEFAULT_SERVER_VERSION);
    }

    public FongoAsyncRule(boolean realMongo, ServerVersion serverVersion) {
        this(FongoRule.randomName(), serverVersion, realMongo, null);
    }

    public FongoAsyncRule(boolean realMongo, MongoClient mongoClientIfReal) {
        this(FongoRule.randomName(), Fongo.DEFAULT_SERVER_VERSION, realMongo, mongoClientIfReal);
    }

    public FongoAsyncRule(String dbName, boolean realMongo) {
        this(dbName, Fongo.DEFAULT_SERVER_VERSION, realMongo, null);
    }

    public FongoAsyncRule(String dbName) {
        this(dbName, Fongo.DEFAULT_SERVER_VERSION, false, null);
    }

    public boolean isRealMongo() {
        return this.realMongo;
    }

    protected void before() throws UnknownHostException {
        if (this.realMongo) {
            if (this.mongo == null) {
                this.mongo = MongoClients.create();
            }
        } else {
            this.mongo = this.fongo.getMongo();
        }
        this.mongoDatabase = this.mongo.getDatabase(this.dbName);
    }

    protected void after() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.mongoDatabase.drop((SingleResultCallback)new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public MongoCollection<Document> newMongoCollection() {
        return this.newMongoCollection(FongoRule.randomName());
    }

    public MongoCollection<Document> newMongoCollection(String collectionName) {
        return this.mongoDatabase.getCollection(collectionName);
    }

    public <T> MongoCollection<T> newMongoCollection(Class<T> documentClass) {
        return this.newMongoCollection(FongoRule.randomName(), documentClass);
    }

    public <T> MongoCollection<T> newMongoCollection(String collectionName, Class<T> documentClass) {
        return this.mongoDatabase.getCollection(collectionName, documentClass);
    }

    protected FongoAsync newFongo(ServerVersion serverVersion) {
        return new FongoAsync("test", serverVersion);
    }

    public FongoAsync getFongo() {
        return this.fongo;
    }

    public MongoDatabase getDatabase(String name) {
        return this.mongo.getDatabase(name);
    }

    public MongoDatabase getDatabase() {
        return this.mongoDatabase;
    }

    public MongoClient getMongoClient() {
        return this.mongo;
    }
}

