/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures;

import com.github.fppt.jedismock.datastructures.Slice;
import java.util.Objects;

public final class ZSetEntry
implements Comparable<ZSetEntry> {
    public static final Double MIN_SCORE = Double.NEGATIVE_INFINITY;
    public static final Double MAX_SCORE = Double.POSITIVE_INFINITY;
    public static final Slice MIN_VALUE = Slice.empty();
    public static final Slice MAX_VALUE = Slice.create("2815bbb7-cacd-4ce1-ba76-11fee7937b0e");
    private final double score;
    private final Slice value;

    public ZSetEntry(double score, Slice value) {
        Objects.requireNonNull(value);
        this.score = score;
        this.value = value;
    }

    public double getScore() {
        return this.score;
    }

    public Slice getValue() {
        return this.value;
    }

    @Override
    public int compareTo(ZSetEntry o) {
        int result = Double.compare(this.score, o.score);
        if (result == 0) {
            if (this.value.equals(o.value)) {
                return 0;
            }
            if (MAX_VALUE.equals(this.value)) {
                return 1;
            }
            if (MAX_VALUE.equals(o.value)) {
                return -1;
            }
            return this.value.compareTo(o.value);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZSetEntry zSetEntry = (ZSetEntry)o;
        return Double.compare(zSetEntry.score, this.score) == 0 && this.value.equals(zSetEntry.value);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.value);
    }
}

