/*
 * Decompiled with CFR 0.152.
 */
package com.github.freva.asciitable;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LineUtils {
    public static Stream<String> lines(String str) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new LineIterator(str), 256), false);
    }

    public static int maxLineLength(String str) {
        int max = 0;
        LineIterator lineIterator = new LineIterator(str);
        while (lineIterator.hasNext()) {
            int start = lineIterator.getPosition();
            max = Math.max(max, lineIterator.getLineEndPositionAndAdvanceToNextLine() - start);
        }
        return max;
    }

    static List<String> splitTextIntoLinesOfMaxLength(String str, int maxCharInLine) {
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder line = new StringBuilder(maxCharInLine);
        int offset = 0;
        while (offset < str.length() && maxCharInLine < str.length() - offset) {
            int spaceToWrapAt = str.lastIndexOf(32, offset + maxCharInLine);
            if (offset < spaceToWrapAt) {
                line.append(str, offset, spaceToWrapAt);
                offset = spaceToWrapAt + 1;
            } else {
                line.append(str, offset, offset + maxCharInLine);
                offset += maxCharInLine;
            }
            lines.add(line.toString());
            line.setLength(0);
        }
        line.append(str.substring(offset));
        lines.add(line.toString());
        return lines;
    }

    private static class LineIterator
    implements Iterator<String> {
        private final String str;
        private int position = 0;
        private boolean newlineLast = true;

        private LineIterator(String str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.newlineLast || this.position < this.str.length();
        }

        @Override
        public String next() {
            int start = this.position;
            return this.str.substring(start, this.getLineEndPositionAndAdvanceToNextLine());
        }

        public int getLineEndPositionAndAdvanceToNextLine() {
            this.newlineLast = false;
            while (this.position < this.str.length()) {
                char ch = this.str.charAt(this.position);
                if (ch == '\n') {
                    this.newlineLast = true;
                    return this.position++;
                }
                if (ch == '\r') {
                    this.newlineLast = true;
                    if (this.position + 1 == this.str.length() || this.str.charAt(this.position + 1) != '\n') {
                        return this.position++;
                    }
                    this.position += 2;
                    return this.position - 2;
                }
                ++this.position;
            }
            return this.position;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

