/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DBusMap<K, V>
implements Map<K, V> {
    Object[][] entries;

    public DBusMap(Object[][] _entries) {
        this.entries = _entries;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        for (Object[] entrie : this.entries) {
            if (key != entrie[0] && (key == null || !key.equals(entrie[0]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object[] entrie : this.entries) {
            if (value != entrie[1] && (value == null || !value.equals(entrie[1]))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        TreeSet<Map.Entry<K, V>> s = new TreeSet<Map.Entry<K, V>>();
        for (int i = 0; i < this.entries.length; ++i) {
            s.add(new Entry(i));
        }
        return s;
    }

    @Override
    public V get(Object key) {
        for (Object[] entrie : this.entries) {
            if (key != entrie[0] && (key == null || !key.equals(entrie[0]))) continue;
            return (V)entrie[1];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.length == 0;
    }

    @Override
    public Set<K> keySet() {
        TreeSet<Object> s = new TreeSet<Object>();
        for (Object[] entry : this.entries) {
            s.add(entry[0]);
        }
        return s;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Object[] entry : this.entries) {
            l.add(entry[1]);
        }
        return l;
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.entries);
    }

    @Override
    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        return ((Map)o).entrySet().equals(this.entrySet());
    }

    public String toString() {
        Object s = "{ ";
        for (Object[] entrie : this.entries) {
            s = (String)s + entrie[0] + " => " + entrie[1] + ",";
        }
        return ((String)s).replaceAll(".$", " }");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class Entry
    implements Map.Entry<K, V>,
    Comparable<Entry> {
        private int entry;

        Entry(int i) {
            this.entry = i;
        }

        @Override
        public boolean equals(Object o) {
            if (null == o) {
                return false;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            return this.entry == ((Entry)o).entry;
        }

        @Override
        public K getKey() {
            return DBusMap.this.entries[this.entry][0];
        }

        @Override
        public V getValue() {
            return DBusMap.this.entries[this.entry][1];
        }

        @Override
        public int hashCode() {
            return DBusMap.this.entries[this.entry][0].hashCode();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Entry e) {
            return this.entry - e.entry;
        }
    }
}

