/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf.junit;

import com.github.javatlacati.contiperf.junit.Parallel;
import com.github.javatlacati.contiperf.junit.ParallelScheduler;
import com.github.javatlacati.contiperf.util.ContiPerfUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class ParallelRunner
extends BlockJUnit4ClassRunner {
    public ParallelRunner(Class<?> type) throws InitializationError {
        super(type);
        this.setScheduler(new ParallelScheduler(ParallelRunner.createExecutor(type)));
    }

    private static ExecutorService createExecutor(Class<?> type) {
        Parallel parallel = ContiPerfUtil.annotationOfClass(type, Parallel.class);
        if (parallel != null) {
            return Executors.newFixedThreadPool(parallel.count(), new ConcurrentTestRunnerThreadFactory());
        }
        return Executors.newCachedThreadPool(new ConcurrentTestRunnerThreadFactory());
    }

    private static class ConcurrentTestRunnerThreadFactory
    implements ThreadFactory {
        private AtomicLong count = new AtomicLong();

        private ConcurrentTestRunnerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, ParallelRunner.class.getSimpleName() + "-Thread-" + this.count.getAndIncrement());
        }
    }
}

