/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf.junit;

import com.github.javatlacati.contiperf.Clock;
import com.github.javatlacati.contiperf.ConcurrentRunner;
import com.github.javatlacati.contiperf.CountRunner;
import com.github.javatlacati.contiperf.EmptyArgumentsProvider;
import com.github.javatlacati.contiperf.ExecutionConfig;
import com.github.javatlacati.contiperf.InvocationRunner;
import com.github.javatlacati.contiperf.PerfTestConfigurationError;
import com.github.javatlacati.contiperf.PerfTestExecutionError;
import com.github.javatlacati.contiperf.PerformanceRequirement;
import com.github.javatlacati.contiperf.PerformanceTracker;
import com.github.javatlacati.contiperf.TimedRunner;
import com.github.javatlacati.contiperf.WaitTimer;
import com.github.javatlacati.contiperf.junit.JUnitInvoker;
import com.github.javatlacati.contiperf.report.ReportContext;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.runners.model.Statement;

final class PerfTestStatement
extends Statement {
    private String id;
    private final Statement base;
    private ReportContext context;
    private ExecutionConfig config;
    private PerformanceRequirement requirement;

    PerfTestStatement(Statement base, String id, ExecutionConfig config, PerformanceRequirement requirement, ReportContext context) {
        this.base = base;
        this.id = id;
        this.config = config;
        this.requirement = requirement;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        System.out.println(this.id);
        JUnitInvoker invoker = new JUnitInvoker(this.id, this.base);
        Clock[] clocks = this.config.getClocks();
        PerformanceTracker tracker = new PerformanceTracker(invoker, this.config, this.requirement, this.context, clocks);
        InvocationRunner runner = this.createRunner(tracker);
        try {
            runner.run();
            if (!tracker.isTrackingStarted() && this.config.getWarmUp() > 0) {
                throw new PerfTestExecutionError("Test finished before warm-up period (" + this.config.getWarmUp() + " ms) was over");
            }
        }
        finally {
            if (tracker.isTrackingStarted()) {
                tracker.stopTracking();
            }
            runner.close();
            tracker.clear();
        }
    }

    private InvocationRunner createRunner(PerformanceTracker tracker) {
        InvocationRunner runner;
        EmptyArgumentsProvider provider = new EmptyArgumentsProvider();
        int threads = this.config.getThreads();
        int rampUp = this.config.getRampUp();
        int durationWithRampUp = this.config.getDuration() + this.config.getRampUp() * (this.config.getThreads() - 1);
        int invocations = this.config.getInvocations();
        WaitTimer waitTimer = this.config.getWaitTimer();
        if (this.config.getDuration() > 0) {
            if (threads == 1) {
                runner = new TimedRunner(tracker, provider, waitTimer, durationWithRampUp);
            } else {
                if (durationWithRampUp - (threads - 1) * rampUp <= 0) {
                    throw new IllegalArgumentException("test duration is shorter than the cumulated ramp-up times");
                }
                InvocationRunner[] runners = new InvocationRunner[threads];
                for (int i = 0; i < threads; ++i) {
                    runners[i] = new TimedRunner(tracker, provider, waitTimer, durationWithRampUp - i * rampUp);
                }
                runner = new ConcurrentRunner(this.id, runners, rampUp);
            }
        } else if (invocations >= 0) {
            AtomicLong counter = new AtomicLong(invocations);
            if (threads == 1) {
                runner = new CountRunner(tracker, provider, waitTimer, counter);
            } else {
                InvocationRunner[] runners = new InvocationRunner[threads];
                for (int i = 0; i < threads; ++i) {
                    runners[i] = new CountRunner(tracker, provider, waitTimer, counter);
                }
                runner = new ConcurrentRunner(this.id, runners, rampUp);
            }
        } else {
            throw new PerfTestConfigurationError("No useful invocation count or duration defined");
        }
        return runner;
    }
}

