/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf.report;

import com.github.javatlacati.contiperf.ExecutionConfig;
import com.github.javatlacati.contiperf.PerformanceRequirement;
import com.github.javatlacati.contiperf.report.AbstractReportModule;
import com.github.javatlacati.stat.LatencyCounter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CSVLatencyReportModule
extends AbstractReportModule {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private File file = null;
    OutputStream out;

    @Override
    public String getReportReferenceLabel(String serviceId) {
        return serviceId == null ? null : "Latency distribution as CSV";
    }

    @Override
    public String getReportReference(String serviceId) {
        return serviceId == null ? null : this.filename(serviceId);
    }

    @Override
    public void starting(String serviceId) {
        this.file = new File(this.context.getReportFolder(), this.filename(serviceId));
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(this.file));
            this.writeHeader(serviceId, this.out);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void completed(String serviceId, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement) {
        this.writeStats(serviceId, counters);
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing " + this.file, e);
        }
    }

    private void writeHeader(String serviceId, OutputStream out) {
        String line = "latency,sampleCount" + LINE_SEPARATOR;
        try {
            out.write(line.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeStats(String serviceId, LatencyCounter[] counters) {
        try {
            LatencyCounter counter = counters[0];
            for (long i = counter.minLatency(); i <= counter.maxLatency(); ++i) {
                String line = i + "," + counter.getLatencyCount(i) + LINE_SEPARATOR;
                this.out.write(line.getBytes());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String filename(String serviceId) {
        return serviceId + ".stat.csv";
    }
}

