/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf.report;

import com.github.javatlacati.contiperf.PercentileRequirement;
import com.github.javatlacati.contiperf.PerformanceRequirement;
import com.github.javatlacati.contiperf.report.Verdict;
import com.github.javatlacati.stat.LatencyCounter;

public class ReportUtil {
    public static boolean success(LatencyCounter counter, PerformanceRequirement requirement) {
        boolean success = ReportUtil.averageVerdict(counter, requirement) != Verdict.FAILURE;
        success &= ReportUtil.maxVerdict(counter, requirement) != Verdict.FAILURE;
        success &= ReportUtil.throughputVerdict(counter, requirement) != Verdict.FAILURE;
        success &= ReportUtil.totalTimeVerdict(counter, requirement) != Verdict.FAILURE;
        success = requirement != null && requirement.isAllowedError() ? (success &= ReportUtil.allowedErrorsVerdict(counter, requirement) != Verdict.FAILURE) : (success &= counter.getAssertionErrors().size() == 0);
        if (requirement != null) {
            PercentileRequirement[] percentileRequirements;
            for (PercentileRequirement percentileRequirement : percentileRequirements = requirement.getPercentileRequirements()) {
                success &= ReportUtil.percentileVerdict(counter, percentileRequirement) != Verdict.FAILURE;
            }
        }
        return success;
    }

    public static Verdict totalTimeVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement == null || requirement.getTotalTime() < 0 || counter.getAssertionErrors().size() > 0) {
            return Verdict.IGNORED;
        }
        return counter.duration() <= (long)requirement.getTotalTime() ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict maxVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement == null || requirement.getMax() < 0 || counter.getAssertionErrors().size() > 0) {
            return Verdict.IGNORED;
        }
        return counter.maxLatency() <= (long)requirement.getMax() ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict throughputVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement == null || requirement.getThroughput() < 0 || counter.getAssertionErrors().size() > 0) {
            return Verdict.IGNORED;
        }
        return counter.throughput() >= (double)requirement.getThroughput() ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict averageVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement == null || requirement.getAverage() < 0 || counter.getAssertionErrors().size() > 0) {
            return Verdict.IGNORED;
        }
        return counter.averageLatency() <= (double)requirement.getAverage() ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict percentileVerdict(LatencyCounter counter, PercentileRequirement requirement) {
        if (requirement == null || requirement.getMillis() < 0 || counter.getAssertionErrors().size() > 0) {
            return Verdict.IGNORED;
        }
        return ReportUtil.percentileVerdict(counter, requirement.getPercentage(), Long.valueOf(requirement.getMillis()));
    }

    public static Verdict percentileVerdict(LatencyCounter counter, int percentage, Long requiredMillis) {
        if (requiredMillis == null || requiredMillis < 0L || counter.getAssertionErrors().size() > 0) {
            return Verdict.IGNORED;
        }
        return counter.percentileLatency(percentage) <= requiredMillis ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict functionalTestVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        if (requirement != null && requirement.isAllowedError()) {
            return ReportUtil.allowedErrorsVerdict(counter, requirement);
        }
        return counter.getAssertionErrors().size() == 0 ? Verdict.SUCCESS : Verdict.FAILURE;
    }

    public static Verdict allowedErrorsVerdict(LatencyCounter counter, PerformanceRequirement requirement) {
        return requirement.getAllowedErrorsRate() >= counter.errorsRate() ? Verdict.SUCCESS : Verdict.FAILURE;
    }
}

