/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDClob;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

class CUBRIDClobWriter
extends Writer {
    private CUBRIDClob clob;
    private long char_pos;

    CUBRIDClobWriter(CUBRIDClob clob, long pos) {
        this.clob = clob;
        this.char_pos = pos;
    }

    public synchronized void write(String str, int off, int len) throws IOException {
        if (this.clob == null) {
            throw new IOException();
        }
        if (str == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > str.length()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.char_pos += (long)this.clob.setString(this.char_pos, str, off, len);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    public synchronized void flush() throws IOException {
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.clob.removeFlushableStream(this);
        this.clob = null;
    }
}

